% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{compute_snpQ2rw}
\alias{compute_snpQ2rw}
\alias{.compute_snpQ2rw}
\title{compute_snpQ2rw}
\usage{
.compute_snpQ2rw(refcount, totcount, pairs, sampsize, readcount, verbose)
}
\arguments{
\item{refcount}{Matrix of nsnpxnpop with counts (genotype or reads) for the reference allele}

\item{totcount}{Matrix of nsnpxnpop with total counts or read coverages}

\item{pairs}{Matrix of npoppairsx2 giving the index for all the pairs of pops included in the computation}

\item{sampsize}{Vector of length npop giving the haploid sample size (not used for count data)}

\item{readcount}{Logical (if TRUE PoolSeq data assumed i.e. weights depending on haploid size, otherwise weights depend on total counts)}

\item{verbose}{Logical (if TRUE progression bar is printed on the terminal)}
}
\value{
Return a vector of length nsnps with SNP-specific Q2
}
\description{
Compute SNP-specific Q2 by averaging over all pairs of samples using weighting averages of pairwise Q2 (eq. A47 in Hivert et al., 2018)
}
\details{
Compute SNP-specific Q2 by averaging over all pairs of samples using weighting averages of pairwise Q2 (eq. A47 in Hivert et al., 2018)
(useful for Fst computation with method Identity).
}
\examples{
#
}
