% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{find_indelneighbor_idx}
\alias{find_indelneighbor_idx}
\alias{.find_indelneighbor_idx}
\title{find_indelneighbor_idx}
\usage{
.find_indelneighbor_idx(contig, position, indels_idx, min_dist, indels_size)
}
\arguments{
\item{contig}{a character string vector corresponding to the CHR field value of the vcf for the markers}

\item{position}{an integer vector corresponding to the POSITION value for the markers}

\item{indels_idx}{vector of (0-indexed) indices of indels}

\item{min_dist}{same as min.dist.from.indels option in \code{\link{vcf2pooldata}}}

\item{indels_size}{size of the indels (associated to indels_idx)}
}
\value{
Return a vector consisting of 1 (if the marker is close to an indel) or 0 (if not)
}
\description{
Search for the closest indels of the markers
}
\details{
Identify if the SNPs are close to an indel
}
\examples{
.find_indelneighbor_idx(c("chr1","chr1","chr1"),c(1000,1004,1020),1,5,2)

}
