% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.leaf.R
\name{add.leaf}
\alias{add.leaf}
\title{Test all possible connection of a leaf to a graph with non-admixed and or admixed edges}
\usage{
add.leaf(
  x,
  leaf.to.add,
  fstats,
  only.test.non.admixed.edges = FALSE,
  only.test.admixed.edges = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{x}{An object of class graph.params or fitted.graph (see details)}

\item{leaf.to.add}{Name of the leaf to add}

\item{fstats}{Object of class fstats that contains estimates of the fstats (see compute.fstats)}

\item{only.test.non.admixed.edges}{If TRUE the function only test non.admixed edges (may be far faster)}

\item{only.test.admixed.edges}{If TRUE the function only test admixed edges}

\item{verbose}{If TRUE extra information is printed on the terminal}

\item{...}{Some parameters to be passed the function fit.graph called internally}
}
\value{
A list with the following elements:
\enumerate{
\item "n.graphs": The number of tested graphs
\item "fitted.graphs.list": a list of fitted.graph objects (indexed from 1 to n.graphs and in the same order as the list "graphs") containing the results of fitting of each graph. 
\item "best.fitted.graph": The graph (object of class fitted.graph) with the minimal BIC (see function fit.graph) among all the graphs within fitted.graphs.list 
\item "bic": a vector of the n.graphs BIC (indexed from 1 to n.graphs and in the same order as the "fitted.graphs.list" list) (see fit.graph details for the computation of the scores). 
}
}
\description{
Test all possible connection of a leaf to a graph with non-admixed and or admixed edges
}
\details{
The input object x needs to be of class graph.params (as generated by the function generate.graph.params) or fitted.graph (as generated by the function fit.graph or by the function add.leaf itself in the graphs.fit.res elements of the output list). This is to ensure that the matrix describing the structure of the graph (graph slot of these objects) is valid (note that it can be plotted for checks). Hence graph.params objects may have been generated without fstats information (that should be supplied independently to the add.leaf function to obtain information on the fstats involving the candidate leaf defined with the leaf.to.add argument).
By default the function tests all the possible positions of a newly added edge connecting the candidate leaf to the graph with both non-admixed (including a new rooting with the candidate leaf as an outgroup) and admixed edges. If n_e is the the number of non-admixed edges of the original graph, the number of tested graphs for non-admixed edges equals n_e+1. The newly added node is named "N-"{name of the leaf to add} (or with more N if the name already exists). For admixed edges, the number of tested graphs equals n_e*(n_e-1)/2 and for a given tested graph, three nodes named "S-"{name of the leaf to add}, "S1-"{name of the leaf to add} and "S2-"{name of the leaf to add} (or with more S if the name already exists) are added and the admixture proportions are named with a letter (A to Z depending on the number of admixed nodes already present in the graph).
}
\seealso{
see \code{\link{fit.graph}} and \code{\link{generate.graph.params}}.
}
