% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computePairwiseFSTmatrix.R
\name{computePairwiseFSTmatrix}
\alias{computePairwiseFSTmatrix}
\title{Compute pairwise population population FST matrix (and possibly all pairwise SNP-specific FST)}
\usage{
computePairwiseFSTmatrix(pooldata, method = "Anova",
  min.cov.per.pool = -1, max.cov.per.pool = 1e+06, min.maf = -1,
  output.snp.values = FALSE)
}
\arguments{
\item{pooldata}{A pooldata object containing Pool-Seq information}

\item{method}{Either "Anova" (default method as described in the manuscript) or "Identity" (relies on an alternative modeling consisting in estimating unbiased Probability of Identity within and across pairs of pools)}

\item{min.cov.per.pool}{Minimal allowed read count (per pool). If at least one pool is not covered by at least min.cov.perpool reads, the position is discarded in the corresponding pairwise comparisons.}

\item{max.cov.per.pool}{Maximal allowed read count (per pool). If at least one pool is covered by more than min.cov.perpool reads, the position is discarded in the corresponding pairwise comparisons.}

\item{min.maf}{Minimal allowed Minor Allele Frequency (computed from the ratio overal read counts for the reference allele over the read coverage)  in the pairwise comparisons.}

\item{output.snp.values}{If TRUE, provide SNP-specific pairwise FST for each comparisons (may lead to a huge result object if the number of pools and/or SNPs is large)}
}
\value{
A list with 2 (or 5 if output.snp.values=TRUE) elements:
\enumerate{
\item "PairwiseFSTmatrix": a matrix with npools rows and npools columns containing the pairwise pool FST estimates
\item "NbOfSNPs": a matrix with npools rows and npools columns containing the number of SNPs satisfying the filtering criteria in pairs of pools (and within each pool in the diagonal)
\item "PairwiseSnpFST" (if output.snp.values=TRUE): a matrix with nsnp rows and (npools*(npools-1))/2 columns containing the SNP-specific FST estimates for each pair of pools
#' \item "PairwiseSnpQ1" (if output.snp.values=TRUE): a matrix with nsnp rows and (npools*(npools-1))/2 columns containing the SNP-specific Q1 estimates for each pair of pools
#' \item "PairwiseSnpQ2" (if output.snp.values=TRUE): a matrix with nsnp rows and (npools*(npools-1))/2 columns containing the SNP-specific Q2 estimates for each pair of pools
}
}
\description{
Compute pairwise population population FST matrix (and possibly all pairwise SNP-specific FST)
}
\examples{
 make.example.files(writing.dir=tempdir())
 pooldata=popsync2pooldata(sync.file=paste0(tempdir(),"/ex.sync.gz"),poolsizes=rep(50,15))
 PairwiseFST=computePairwiseFSTmatrix(pooldata)
}
\seealso{
To generate subset of pooldata object, see \code{\link{pooldata.subset}}
}
