% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeFST.R
\name{computeFST}
\alias{computeFST}
\title{Compute FST from Pool-Seq data}
\usage{
computeFST(pooldata, method = "MoM", snp.index = NA)
}
\arguments{
\item{pooldata}{A pooldata object containing Pool-Seq information}

\item{method}{Either "MoM" (default method as described in the manuscript) or "PiD" (relies on an alternative modeling consisting in estimating unbiased Probability of Identity within and across pairs of pools)}

\item{snp.index}{A list of SNP to be considered in the computation (by default all the SNP are considered)}
}
\value{
A list with the four following elements:
\enumerate{
\item "FST": a scalar corresponding to the estimate the global FST
\item "snp.FST": a vector containing estimates of SNP-specific FST
\item "snp.Q1": a vector containing estimates of the overall within pop. SNP-specific probability of identity
\item "snp.Q2": a vector containing estimates of the overall between pop. SNP-specific probability of identity
}
}
\description{
Compute FST from Pool-Seq data
}
\examples{
 make.example.files(writing.dir=tempdir())
 pooldata=popsync2pooldata(sync.file=paste0(tempdir(),"/ex.sync.gz"),poolsizes=rep(50,15))
 res.fst=computeFST(pooldata)
}
\seealso{
To generate pooldata object, see \code{\link{vcf2pooldata}}, \code{\link{popsync2pooldata}}
}
