% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_pool.R
\name{poolReads}
\alias{poolReads}
\title{Reads contributed by each pool}
\usage{
poolReads(nPools, coverage, probs)
}
\arguments{
\item{nPools}{an integer indicating how many pools were used to sequence the
population.}

\item{coverage}{a vector containing the total depth of coverage of the
population. Each entry of the vector represents a different site.}

\item{probs}{a matrix containing the probability of contribution of each pool
used to sequence the population. This matrix can be obtained with the
\code{poolProbs} function.}
}
\value{
a matrix with the number of reads contributed by each pool towards
the total coverage of the population. Each row of the matrix is a different
pool and each column a different site.
}
\description{
This function simulates the contribution, in terms of reads, of each pool.
The number of reads contributed from all pools is equal to the total coverage
of the population.
}
\examples{
# simulate the probability of contribution of each pool
probs <- poolProbs(nPools = 5, vector_np = rep(10, 5), nSNPs = 8, pError = 50)

# simulate the number of reads contributed, assuming 10x coverage for each site
poolReads(nPools = 5, coverage = rep(10, 8), probs = probs)

}
