% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probe_match.R
\docType{methods}
\name{probe_match}
\alias{probe_match}
\alias{probe_objfun}
\alias{probe_objfun,missing-method}
\alias{probe_objfun,ANY-method}
\alias{probe_objfun,data.frame-method}
\alias{probe_objfun,pomp-method}
\alias{probe_objfun,probed_pomp-method}
\alias{probe_objfun,probe_match_objfun-method}
\title{Probe matching}
\usage{
\S4method{probe_objfun}{data.frame}(
  data,
  est = character(0),
  fail.value = NA,
  probes,
  nsim,
  seed = NULL,
  params,
  rinit,
  rprocess,
  rmeasure,
  partrans,
  ...,
  verbose = getOption("verbose", FALSE)
)

\S4method{probe_objfun}{pomp}(
  data,
  est = character(0),
  fail.value = NA,
  probes,
  nsim,
  seed = NULL,
  ...,
  verbose = getOption("verbose", FALSE)
)

\S4method{probe_objfun}{probed_pomp}(
  data,
  est = character(0),
  fail.value = NA,
  probes,
  nsim,
  seed = NULL,
  ...,
  verbose = getOption("verbose", FALSE)
)

\S4method{probe_objfun}{probe_match_objfun}(
  data,
  est,
  fail.value,
  seed = NULL,
  ...,
  verbose = getOption("verbose", FALSE)
)
}
\arguments{
\item{data}{either a data frame holding the time series data,
or an object of class \sQuote{pomp},
i.e., the output of another \pkg{pomp} calculation.
Internally, \code{data} will be coerced to an array with storage-mode \code{double}.}

\item{est}{character vector; the names of parameters to be estimated.}

\item{fail.value}{optional numeric scalar;
if non-\code{NA}, this value is substituted for non-finite values of the objective function.
It should be a large number (i.e., bigger than any legitimate values the objective function is likely to take).}

\item{probes}{a single probe or a list of one or more probes.
A probe is simply a scalar- or vector-valued function of one argument that can be applied to the data array of a \sQuote{pomp}.
A vector-valued probe must always return a vector of the same size.
A number of useful probes are provided with the package:
see \link[=basic_probes]{basic probes}.}

\item{nsim}{the number of model simulations to be computed.}

\item{seed}{integer.
When fitting, it is often best to fix the seed of the random-number generator (RNG).
This is accomplished by setting \code{seed} to an integer.
By default, \code{seed = NULL}, which does not alter the RNG state.}

\item{params}{optional; named numeric vector of parameters.
This will be coerced internally to storage mode \code{double}.}

\item{rinit}{simulator of the initial-state distribution.
This can be furnished either as a C snippet, an \R function, or the name of a pre-compiled native routine available in a dynamically loaded library.
Setting \code{rinit=NULL} sets the initial-state simulator to its default.
For more information, see \link[=rinit_spec]{rinit specification}.}

\item{rprocess}{simulator of the latent state process, specified using one of the \link[=rprocess_spec]{rprocess plugins}.
Setting \code{rprocess=NULL} removes the latent-state simulator.
For more information, see \link[=rprocess_spec]{rprocess specification for the documentation on these plugins}.}

\item{rmeasure}{simulator of the measurement model, specified either as a C snippet, an \R function, or the name of a pre-compiled native routine available in a dynamically loaded library.
Setting \code{rmeasure=NULL} removes the measurement model simulator.
For more information, see \link[=rmeasure_spec]{rmeasure specification}.}

\item{partrans}{optional parameter transformations, constructed using \code{\link{parameter_trans}}.

Many algorithms for parameter estimation search an unconstrained space of parameters.
When working with such an algorithm and a model for which the parameters are constrained, it can be useful to transform parameters.
One should supply the \code{partrans} argument via a call to \code{\link{parameter_trans}}.
For more information, see \link[=parameter_trans]{parameter_trans}.
Setting \code{partrans=NULL} removes the parameter transformations, i.e., sets them to the identity transformation.}

\item{...}{additional arguments are passed to \code{\link{pomp}}.}

\item{verbose}{logical; if \code{TRUE}, diagnostic messages will be printed to the console.}
}
\value{
\code{probe_objfun} constructs a stateful objective function for probe matching.
Specifically, \code{probe_objfun} returns an object of class \sQuote{probe_match_objfun}, which is a function suitable for use in an \code{\link[stats]{optim}}-like optimizer.
In particular, this function takes a single numeric-vector argument that is assumed to contain the parameters named in \code{est}, in that order.
When called, it will return the negative synthetic log likelihood for the probes specified.
It is a stateful function:
Each time it is called, it will remember the values of the parameters and its estimate of the synthetic likelihood.
}
\description{
Estimation of parameters by maximum synthetic likelihood
}
\details{
In probe-matching, one attempts to minimize the discrepancy between simulated and actual data, as measured by a set of summary statistics called \emph{probes}.
In \pkg{pomp}, this discrepancy is measured using the \dQuote{synthetic likelihood} as defined by Wood (2010).
}
\section{Note for Windows users}{


Some Windows users report problems when using C snippets in parallel computations.
These appear to arise when the temporary files created during the C snippet compilation process are not handled properly by the operating system.
To circumvent this problem, use the \code{\link[=pomp]{cdir}} and \code{\link[=pomp]{cfile}} options to cause the C snippets to be written to a file of your choice, thus avoiding the use of temporary files altogether.
}

\section{Important Note}{

Since \pkg{pomp} cannot guarantee that the \emph{final} call an optimizer makes to the function is a call \emph{at} the optimum, it cannot guarantee that the parameters stored in the function are the optimal ones.
Therefore, it is a good idea to evaluate the function on the parameters returned by the optimization routine, which will ensure that these parameters are stored.
}

\section{Warning! Objective functions based on C snippets}{

If you use C snippets (see \code{\link{Csnippet}}), a dynamically loadable library will be built.
As a rule, \pkg{pomp} functions load this library as needed and unload it when it is no longer needed.
The stateful objective functions are an exception to this rule.
For efficiency, calls to the objective function do not execute \code{\link{pompLoad}} or \code{\link{pompUnload}}:
rather, it is assumed that \code{\link{pompLoad}} has been called before any call to the objective function.
When a stateful objective function using one or more C snippets is created, \code{\link{pompLoad}} is called internally to build and load the library:
therefore, within a single \R session, if one creates a stateful objective function, one can freely call that objective function and (more to the point) pass it to an optimizer that calls it freely, without needing to call \code{\link{pompLoad}}.
On the other hand, if one retrieves a stored objective function from a file, or passes one to another \R session, one must call \code{\link{pompLoad}} before using it.
\strong{Failure to do this will typically result in a segmentation fault (i.e., it will crash the \R session).}
}

\examples{
\donttest{
  gompertz() -> po
  
  ## A list of probes:
  plist <- list(
    mean=probe_mean("Y",trim=0.1,transform=sqrt),
    sd=probe_sd("Y",transform=sqrt),
    probe_marginal("Y",ref=obs(po)),
    probe_acf("Y",lags=c(1,3,5),type="correlation",transform=sqrt),
    probe_quantile("Y",prob=c(0.25,0.75),na.rm=TRUE)
  )

  ## Construct the probe-matching objective function.
  ## Here, we just want to estimate 'K'.
  po |>
    probe_objfun(probes=plist,nsim=100,seed=5069977,
      est="K") -> f

  ## Any numerical optimizer can be used to minimize 'f'.
  if (require(subplex)) {

    subplex(fn=f,par=0.4,control=list(reltol=1e-5)) -> out

  } else {

    optim(fn=f,par=0.4,control=list(reltol=1e-5)) -> out

  }

  ## Call the objective one last time on the optimal parameters:
  f(out$par)
  coef(f)

  ## There are 'plot' and 'summary' methods:
  f |> as("probed_pomp") |> plot()
  f |> summary()

  ## One can convert an objective function to a data frame:
  f |> as("data.frame") |> head()
  f |> as("probed_pomp") |> as("data.frame") |> head()

  f |> probe() |> plot()

  ## One can modify the objective function with another call
  ## to 'probe_objfun':

  f |> probe_objfun(est=c("r","K")) -> f1
  optim(fn=f1,par=c(0.3,0.3),control=list(reltol=1e-5)) -> out
  f1(out$par)
  coef(f1)
}
}
\references{
\Kendall1999

\Wood2010
}
\seealso{
\code{\link[stats]{optim}} \code{\link[subplex]{subplex}} \code{\link[nloptr]{nloptr}}

More on methods based on summary statistics: 
\code{\link{abc}()},
\code{\link{basic_probes}},
\code{\link{nlf}},
\code{\link{probe}()},
\code{\link{spect}()},
\code{\link{spect_match}}

More on \pkg{pomp} estimation algorithms:
\code{\link{abc}()},
\code{\link{bsmc2}()},
\code{\link{estimation_algorithms}},
\code{\link{mif2}()},
\code{\link{nlf}},
\code{\link{pmcmc}()},
\code{\link{pomp-package}},
\code{\link{spect_match}}

More on maximization-based estimation methods:
\code{\link{mif2}()},
\code{\link{nlf}},
\code{\link{spect_match}},
\code{\link{traj_match}}
}
\author{
Aaron A. King
}
\concept{estimation methods}
\concept{methods based on maximization}
\concept{probe matching}
\concept{summary statistic-based methods}
\concept{synthetic likelihood}
