% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pomcheck.R
\name{pomcheck}
\alias{pomcheck}
\alias{pomcheck.default}
\alias{pomcheck.formula}
\title{Graphical check for proportional odds assumption}
\usage{
pomcheck(object, ...)

\method{pomcheck}{default}(object, x, data, ...)

\method{pomcheck}{formula}(formula, data, ...)
}
\arguments{
\item{object}{character string for response}

\item{\dots}{currently unused}

\item{x}{vector of character string(s) for explanatory variable(s)}

\item{data}{data frame containing the variables}

\item{formula}{formula of the form y ~ x1 + x2 + ...}
}
\value{
an object of class 'pomcheck'
}
\description{
Implements the method described in \url{https://stats.idre.ucla.edu/r/dae/ordinal-logistic-regression/}
for checking if the proportional odds assumption holds for a cumulative logit model.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: default

\item \code{formula}: supports formula specification
}}

\examples{
pomcheck(Species ~ Sepal.Length, iris)
pomcheck(Species ~ Sepal.Length + Sepal.Width, iris)
pomcheck(object="Species", x="Sepal.Length", iris)
pomcheck(object="Species", x=c("Sepal.Length", "Sepal.Width"), iris)
}
\seealso{
\code{\link{plot.pomcheck}}
}
