% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polypoly-package.R
\name{poly_rescale}
\alias{poly_rescale}
\title{Rescale the range of a polynomial matrix}
\usage{
poly_rescale(x, scale_width = 1)
}
\arguments{
\item{x}{a matrix created by \code{\link[stats:poly]{stats::poly()}}}

\item{scale_width}{the desired range (max - min) for the first column of the matrix}
}
\value{
the rescaled polynomial matrix (as a plain matrix with \code{coefs}
attribute removed)
}
\description{
Rescale the range of a polynomial matrix
}
\details{
This function strips away the \code{poly} class and the \code{coefs}
attribute of the matrix. This is because those attributes no longer
describe the transformed matrix.
}
\examples{
m <- poly(1:10, degree = 4)

# Difference between min and max values of first column is 10
scaled <- poly_rescale(m, scale_width = 10)
scaled

# Rescaled values are still orthogonal
zapsmall(cor(scaled))
}
