% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranges.R
\name{ranges}
\alias{ranges}
\alias{ranges,corpus-method}
\alias{ranges,character-method}
\alias{ranges,subcorpus-method}
\alias{ranges,partition-method}
\title{Get ranges for query.}
\usage{
ranges(.Object, ...)

\S4method{ranges}{corpus}(
  .Object,
  query,
  cqp = FALSE,
  check = TRUE,
  p_attribute = "word",
  verbose = TRUE,
  mc = 1L,
  progress = FALSE
)

\S4method{ranges}{character}(
  .Object,
  query,
  cqp = FALSE,
  check = TRUE,
  p_attribute = "word",
  verbose = TRUE,
  mc = 1L,
  progress = FALSE
)

\S4method{ranges}{subcorpus}(
  .Object,
  query,
  cqp = FALSE,
  check = TRUE,
  p_attribute = "word",
  verbose = TRUE,
  mc = 1L,
  progress = FALSE
)

\S4method{ranges}{partition}(
  .Object,
  query,
  cqp = FALSE,
  check = TRUE,
  p_attribute = "word",
  verbose = TRUE,
  mc = 1L,
  progress = FALSE
)
}
\arguments{
\item{.Object}{A length-one \code{character} vector indicating a CWB corpus, a
\code{partition} object, or a \code{matrix} with corpus positions.}

\item{...}{Used for reasons of backwards compatibility to
process arguments that have been renamed (e.g. \code{pAttribute}).}

\item{query}{A \code{character} vector providing one or multiple queries (token to
look up, regular expression or CQP query). Token ids (i.e. \code{integer}
values) are also accepted. If \code{query} is neither a regular expression nor a
CQP query, a sanity check removes accidental leading/trailing whitespace,
issuing a respective warning.}

\item{cqp}{Either logical (\code{TRUE} if query is a CQP query), or a function to
check whether query is a CQP query or not (defaults to \code{is.cqp} auxiliary
function).}

\item{check}{A \code{logical} value, whether to check validity of CQP query
using \code{check_cqp_query}.}

\item{p_attribute}{The p-attribute to search. Needs to be stated only if query
is not a CQP query. Defaults to \code{NULL}.}

\item{verbose}{A \code{logical} value, whether to show messages.}

\item{mc}{If \code{logical} value \code{TRUE}, the value of
\code{getOption("polmineR.cores")} is passed into \code{mclapply} or
\code{pblapply} as the specification of the number of cores to use. It is
also possible to supply an integer value with the number of cores directly.
Defaults to 1 (no multicore). Relevant only if several queries are to be
processed.}

\item{progress}{A \code{logical} value, whether to show a progess bar when
processing multiple queries.}
}
\description{
Get ranges (pairs of left and right corpus positions) for queries.
}
