% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partition_method.R
\docType{methods}
\name{partition}
\alias{partition}
\alias{partition,character-method}
\alias{partition,list-method}
\alias{partition,environment-method}
\alias{partition,partition-method}
\alias{partition,Corpus-method}
\title{Initialize a partition.}
\usage{
partition(.Object, ...)

\S4method{partition}{character}(.Object, def = NULL, name = "",
  encoding = NULL, pAttribute = NULL, regex = FALSE, xml = "flat",
  decode = TRUE, type = NULL, mc = FALSE, verbose = TRUE, ...)

\S4method{partition}{list}(.Object, ...)

\S4method{partition}{environment}(.Object, slots = c("name", "corpus", "size",
  "pAttribute"))

\S4method{partition}{partition}(.Object, def = NULL, name = "",
  regex = FALSE, pAttribute = NULL, decode = TRUE, xml = NULL,
  verbose = TRUE, mc = FALSE, ...)

\S4method{partition}{Corpus}(.Object, def = NULL, name = "",
  encoding = NULL, regex = FALSE, xml = "flat", type = NULL,
  verbose = TRUE, ...)
}
\arguments{
\item{.Object}{character-vector - the CWB-corpus to be used}

\item{...}{parameters passed into the partition-method}

\item{def}{list consisting of a set of character vectors (see
details and examples)}

\item{name}{name of the new partition, defaults to "}

\item{encoding}{encoding of the corpus (typically "LATIN1 or "(UTF-8)), if NULL, the encoding provided in the registry file of the corpus (charset="...") will be used b}

\item{pAttribute}{the pAttribute(s) for which term frequencies shall be retrieved}

\item{regex}{logical (defaults to FALSE)}

\item{xml}{either 'flat' (default) or 'nested'}

\item{decode}{whether to turn token ids to strings (set FALSE to minimize object.size / memory consumption)}

\item{type}{character vector (length 1) specifying the type of corpus / partition (e.g. "plpr")}

\item{mc}{whether to use multicore (for counting terms)}

\item{verbose}{logical, defaults to TRUE}

\item{slots}{character vector}
}
\value{
An object of the S4 class 'partition'
}
\description{
Create a subcorpus stored in an object of the \code{partition} class.
Counts are performed for the p-attribute defined by the parameter \code{pAttribute}.
}
\details{
The function sets up a partition (subcorpus) based on a list of s-attributes with respective values.

The s-attributes defining the partition can be passed in as a list, e.g. list(interjection="speech",
year="2013"), or - for convencience - directly.

The values defining the partition may contain regular expressions. To use regular expression syntax, set the 
parameter regex to \code{"TRUE"}. Regular expressions are passed into grep, i.e. the regex syntax
used in R needs to be used (double backlashes etc.). If regular expressions are used, the length
of the character vector needs to be 1. If regex is \code{"FALSE"}, the length of the character
vectors can be > 1, matching s-attributes are identifies with the operator \code{in}.

The XML imported into the CWB may be "flat" or "nested". This needs to be indicated with the
parameter \code{xml} (default is "flat"). If you generate a partition based on a 
flat XML structure, some performance gain may be achieved when ordering the sAttributes
with decreasingly restrictive conditions. If you have a nested XML, it is mandatory that the
order of the sAttributes provided reflects the hierarchy of the XML: The top-level elements
need to be positioned at the beginning of the list with the s-attributes, the the most restrictive
elements at the end.

If pAttribute is not NULL, a count of tokens in the corpus will be performed and kept in the
\code{stat}-slot of the partition-object. The length of the pAttribute character vector may be 1
or more. If two or more p-attributes are provided, The occurrence of combinations will be counted.
A typical scenario is to combine the p-attributes "word" or "lemma" and "pos".
}
\examples{
use("polmineR")
spd <- partition("GERMAPARLMINI", party = "SPD", interjection = "speech")
kauder <- partition("GERMAPARLMINI", speaker = "Volker Kauder", pAttribute = "word")
merkel <- partition("GERMAPARLMINI", speaker = ".*Merkel", pAttribute = "word", regex = TRUE)
sAttributes(merkel, "date")
sAttributes(merkel, "speaker")
merkel <- partition(
  "GERMAPARLMINI", speaker = "Angela Dorothea Merkel",
  date = "2009-11-10", interjection = "speech", pAttribute = "word"
  )
merkel <- subset(merkel, !word \%in\% punctuation)
merkel <- subset(merkel, !word \%in\% tm::stopwords("de"))
   
# a certain defined time segment
days <- seq(
  from = as.Date("2009-10-28"),
  to = as.Date("2009-11-11"),
  by = "1 day"
)
period <- partition("GERMAPARLMINI", date = days)
}
\seealso{
To learn about the methods available for objects of the class partition, see
\code{\link{partition_class}},
}
\author{
Andreas Blaette
}
