% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/context_class.R, R/count_method.R
\docType{class}
\name{context-class}
\alias{context-class}
\alias{show,context-method}
\alias{[,context-method}
\alias{[,context,ANY,ANY,ANY-method}
\alias{[[,context-method}
\alias{summary,context-method}
\alias{head,context-method}
\alias{as.DataTables,context-method}
\alias{count,context-method}
\title{S4 context class}
\usage{
\S4method{count}{context}(.Object)
}
\arguments{
\item{.Object}{object}
}
\description{
class to organize information of context analysis
}
\section{Slots}{

\describe{
\item{\code{query}}{Object of class \code{"character"} node examined}

\item{\code{count}}{Object of class \code{"numeric"} number of hits}

\item{\code{partition}}{Object of class \code{"partition"} the partition the analysis is based on}

\item{\code{partitionSize}}{Object of class \code{"numeric"} the size of the partition}

\item{\code{left}}{Object of class \code{"numeric"} number of tokens to the left}

\item{\code{right}}{Object of class \code{"numeric"} number of tokens to the right}

\item{\code{size}}{Object of class \code{"numeric"} number of tokens in the right and left context}

\item{\code{sAttribute}}{Object of class \code{"character"} s-attribute}

\item{\code{pAttribute}}{Object of class \code{"character"} p-attribute of the query}

\item{\code{corpus}}{Object of class \code{"character"} the CWB corpus used}

\item{\code{stat}}{Object of class \code{"data.table"} statistics of the analysis}

\item{\code{encoding}}{Object of class \code{"character"} encoding of the corpus}

\item{\code{cpos}}{Object of class \code{"list"} corpus positions of the hits}

\item{\code{method}}{Object of class \code{"character"} statistical test used}

\item{\code{call}}{Object of class \code{"character"} call that generated the object}
}}

