% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTokenStream_method.R
\docType{methods}
\name{getTokenStream}
\alias{getTokenStream}
\alias{getTokenStream,Regions-method}
\alias{getTokenStream,character-method}
\alias{getTokenStream,matrix-method}
\alias{getTokenStream,numeric-method}
\alias{getTokenStream,partition-method}
\title{Get Token Stream Based on Corpus Positions.}
\usage{
getTokenStream(.Object, ...)

\S4method{getTokenStream}{numeric}(.Object, corpus, pAttribute,
  encoding = NULL, collapse = NULL, beautify = TRUE, cpos = FALSE,
  cutoff = NULL)

\S4method{getTokenStream}{matrix}(.Object, ...)

\S4method{getTokenStream}{character}(.Object, left = NULL, right = NULL,
  ...)

\S4method{getTokenStream}{partition}(.Object, pAttribute, collapse = NULL,
  cpos = FALSE, ...)

\S4method{getTokenStream}{Regions}(.Object, pAttribute = "word", ...)
}
\arguments{
\item{.Object}{an object of class \code{matrix} or \code{partition}}

\item{...}{further arguments}

\item{corpus}{the CWB corpus}

\item{pAttribute}{the pAttribute to decode}

\item{encoding}{encoding to use}

\item{collapse}{character string length 1}

\item{beautify}{logical, whether to adjust whitespace before and after interpunctation}

\item{cpos}{logical, whether to return cpos as names of the tokens}

\item{cutoff}{maximum number of tokens to be reconstructed}

\item{left}{left corpus position}

\item{right}{right corpus position}
}
\description{
Turn regions of a corpus defined by corpus positions into the original text.
}

