% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cooccurrences_method.R
\docType{methods}
\name{cooccurrences}
\alias{cooccurrences}
\alias{cooccurrences,partition-method}
\alias{cooccurrences,partitionBundle-method}
\title{get all cooccurrences in a partition}
\usage{
cooccurrences(.Object, ...)

\S4method{cooccurrences}{partition}(.Object, window = 5, keep = list(pos =
  c("NN", "ADJA")), method = "ll", big = FALSE, matrix = FALSE,
  mc = FALSE, progress = TRUE, verbose = TRUE, ...)

\S4method{cooccurrences}{partitionBundle}(.Object, mc = FALSE, ...)
}
\arguments{
\item{.Object}{a partition object}

\item{...}{further parameters that will be passed into bigmatrix (applies only of big=TRUE)}

\item{window}{no of tokens to the left and to the right of nodes}

\item{keep}{list with tokens to keep}

\item{method}{statistical test to use (defaults to "ll")}

\item{big}{logical, whether to use bigmatrix}

\item{matrix}{logical, whether to return matrix}

\item{mc}{whether to use multicore}

\item{progress}{logical, whether to be verbose}

\item{verbose}{logical, whether to be verbose}
}
\value{
a cooccurrences-class object
}
\description{
get all cooccurrences in a partition
}
\examples{
if (require(polmineR.sampleCorpus) && require(rcqp)){
  merkel <- partition("PLPRBTTXT", text_type="speech", text_name=".*Merkel", regex=TRUE)
  merkel <- enrich(merkel, pAttribute="word")
  cooc <- cooccurrences(merkel)
}
}
\author{
Andreas Blaette
}

