% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/charts.R
\name{pollster_charts}
\alias{pollster_charts}
\alias{pollstr_charts}
\title{Get list of available charts}
\usage{
pollster_charts(page = 1, topic = NULL, state = NULL, showall = NULL,
  convert = TRUE, max_pages = 1)

pollstr_charts(page = 1, topic = NULL, state = NULL, showall = NULL,
  convert = TRUE, max_pages = 1)
}
\arguments{
\item{page}{Page to get. The API returns results in pages of 100.}

\item{topic}{Only include charts related to a specific topic. See \url{http://elections.huffingtonpost.com/pollster/api} for examples.}

\item{state}{Only include charts from a single state. Use 2-letter state abbreviations. "US" will return all national charts.}

\item{showall}{logical Include charts for races that were once possible but didn't happen (e.g. Gingrich vs. Obama 2012)}

\item{convert}{Rearrange the data returned by the API into easier to use data frames.}

\item{max_pages}{Maximum number of pages to get.}
}
\value{
If \code{convert=TRUE}, a \code{"pollster_charts"} object with elements
\describe{
  \item{\code{charts}}{Data frame with data on charts.}
  \item{\code{estimates}}{Data frame with current estimates from each chart. The column \code{slug} matches this data frame to \code{charts}}
}
Otherwise, a \code{"list"} in the original structure of the json returned by the API.
}
\description{
Get list of available charts
}
\examples{
\dontrun{
 # Get charts related to Washington
 pollster_charts(state = 'WA')
 # Get national charts
 pollster_charts(state='US')
 # Get charts for the topic '2016-president'
 pollster_charts(topic = '2016-president')
 # Get all charts
 pollster_charts()
 # By default, this only returns the first 100 charts, to get more
 # set max_pages higher. Use Inf, to ensure you get all.
 pollster_charts(topic = '2016-president', max_pages = Inf)
}
}
\references{
\url{http://elections.huffingtonpost.com/pollster/api}
}

