% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/policy_eval_functions.R
\name{conditional}
\alias{conditional}
\title{Conditional Policy Evaluation}
\usage{
conditional(object, policy_data, baseline)
}
\arguments{
\item{object}{Policy evaluation object created by \code{\link[=policy_eval]{policy_eval()}}.}

\item{policy_data}{Policy data object created by \code{\link[=policy_data]{policy_data()}}.}

\item{baseline}{Character string.}
}
\value{
object of inherited class 'estimate', see \link[lava:estimate.default]{lava::estimate.default}.
The object is a list with elements 'coef' (policy value estimate for each
group) and 'IC' (influence curve estimate matrix).
}
\description{
\code{conditional()} is used to calculate the
policy value for each group defined by a given baseline variable.
}
\examples{
library("polle")
library("data.table")
setDTthreads(1)
d <- sim_single_stage(n=2e3)
pd <- policy_data(d,
                  action = "A",
                  baseline = c("B"),
                  covariates = c("Z","L"),
                  utility = "U")

# static policy:
p <- policy_def(1)

pe <- policy_eval(pd,
                  policy = p)

# conditional value for each group defined by B
conditional(pe, pd, "B")
}
