% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/policy_data_functions.R
\name{get_n}
\alias{get_n}
\title{Get Number of Observations}
\usage{
get_n(object)
}
\arguments{
\item{object}{Object of class \link{policy_data}.}
}
\value{
Integer.
}
\description{
\code{get_n} returns the number of observations in
the policy data object.
}
\examples{
### Two stages:
d <- sim_two_stage(5e2, seed=1)
# constructing policy_data object:
pd <- policy_data(d,
                  action = c("A_1", "A_2"),
                  baseline = c("B"),
                  covariates = list(L = c("L_1", "L_2"),
                                    C = c("C_1", "C_2")),
                  utility = c("U_1", "U_2", "U_3"))
pd

# getting the number of observations:
get_n(pd)
}
