% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_03_app_users.R
\name{get_app_users}
\alias{get_app_users}
\title{Polished API - Get App(s) User(s)}
\usage{
get_app_users(
  app_uid = NULL,
  user_uid = NULL,
  email = NULL,
  api_key = get_api_key()
)
}
\arguments{
\item{app_uid}{an optional app uid.}

\item{user_uid}{an optional user uid.}

\item{email}{an optional user email address.}

\item{api_key}{your Polished API key.  Set your polished api key using \code{\link{set_api_key}()}
so that you do not need to supply this argument with each function call.}
}
\value{
an object of class \code{polished_api_res}.  When successful, the \code{content} of the object is a
tibble of app(s) with the following columns:
\itemize{
\item \code{uid}
\item \code{app_uid}
\item \code{user_uid}
\item \code{is_admin}
\item \code{created_at}
\item \code{email}
}
}
\description{
Polished API - Get App(s) User(s)
}
\details{
If \code{app_uid}, \code{user_uid}, & \code{email} are all \code{NULL},
then all app users will be returned.
}
\seealso{
\code{\link[=add_app_user]{add_app_user()}} \code{\link[=update_app_user]{update_app_user()}} \code{\link[=delete_app_user]{delete_app_user()}}
}
