% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poismf.R
\name{topN.new}
\alias{topN.new}
\title{Rank top-N highest-predicted items for a new user}
\usage{
topN.new(
  model,
  X,
  n = 10,
  include = NULL,
  exclude = NULL,
  output_score = FALSE,
  l2_reg = model$l2_reg,
  l1_reg = model$l1_reg,
  weight_mult = model$weight_mult,
  maxupd = max(1000L, model$maxupd)
)
}
\arguments{
\item{model}{A Poisson factorization model as returned by `poismf`.}

\item{X}{Data with the non-zero item indices and counts for this new user. Can be
passed as a sparse vector from package `Matrix` (`Matrix::dsparseVector`, which can
be created from indices and values through `Matrix::sparseVector`), or as a `data.frame`,
in which case will take the first column as the item/column indices
(numeration starting at 1) and the second column
as the counts. If `X` passed to `poismf` was a `data.frame`, `X` here must also be
a `data.frame`.}

\item{n}{Number of top-N highest-predicted results to output.}

\item{include}{List of items which will be ranked. If passing this, will only
make a ranking among these items. If `X` passed to `poismf` was a
`data.frame`, must match with the entries in its second column,
otherwise should match with the columns of `X` (numeration starting at 1). Can only pass
one of `include` or `exclude.` Must not contain duplicated entries.}

\item{exclude}{List of items to exclude from the ranking. If passing this, will
rank all the items except for these. If `X` passed to `poismf` was a
`data.frame`, must match with the entries in its second column,
otherwise should match with the columns of `X` (numeration starting at 1). Can only pass
one of `include` or `exclude`. Must not contain duplicated entries.}

\item{output_score}{Whether to output the scores in addition to the IDs. If passing
`FALSE`, will return a single array with the item IDs, otherwise
will return a list with the item IDs and the scores.}

\item{l2_reg}{Strength of L2 regularization to use for optimizing the new factors.}

\item{l1_reg}{Strength of the L1 regularization. Not recommended.}

\item{weight_mult}{Weight multiplier for the positive entries over the missing entries.}

\item{maxupd}{Maximum number of TNCG updates to perform. You might want to
increase this value depending on the use-case.}
}
\value{
\itemize{
  \item If passing `output_score=FALSE` (the default), will return a vector of size `n`
  with the top-N highest predicted items for this user.If the `X` data passed to
  `poismf` was a `data.frame`, will contain the item IDs from its second column,
  otherwise will be integers matching to the columns of `X` (starting at 1). If
  `X` was passed as `data.frame`, the entries in this vector might be coerced to
  character regardless of their original type.
  \item If passing `output_score=TRUE`, will return a list, with the first entry
  being the vector described above under name `ix`, and the second entry being the
  associated scores, as a numeric vector of size `n`.
}
}
\description{
Rank top-N highest-predicted items for a new user
}
\details{
This function calculates the latent factors in the same way as
`factors.single` - see the documentation of \link{factors.single}
for details.

Just like \link{topN}, it does not exploit any potential sparsity in the
fitted matrices and vectors, so it might be a lot faster to produce the
recommendations externally (see the documentation for \link{topN} for details).

The factors are initialized to the mean of each column in the fitted model.
}
\seealso{
\link{factors.single} \link{topN}
}
