% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poismf.R
\name{calc.all.counts}
\alias{calc.all.counts}
\title{Predict whole input matrix}
\usage{
calc.all.counts(model)
}
\arguments{
\item{model}{A Poisson factorization model as output by function `poismf`.}
}
\value{
A matrix `dimA` x `dimB` with the full predictions for all rows and column.
If the inputs did not have numbers as IDs, the equivalences to their IDs in the outputs
are in the `model` object under fields `levels_A` and `levels_B`, and can also be
obtained through function \link{get.model.mappings}.
}
\description{
Outputs the predictions for the whole input matrix to which the model was fit.
Note that this will be a dense matrix, and in typical recommender systems scenarios will
likely not fit in memory.
}
