% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/po-object.R
\name{po}
\alias{po}
\title{Create an object of class po}
\usage{
po(source_type, file_type, initial_comments, metadata, direct, countable)
}
\arguments{
\item{source_type}{Either "r" or "c", depending upon whether the messages
originated from R-level code, or C-level code.}

\item{file_type}{Either "po" or "pot", depending upon whether the messages
originated from a PO (language-specific) or POT (master translation) file.}

\item{initial_comments}{A character vector of comments added by the
translator.}

\item{metadata}{A \code{\link[tibble]{tibble}} of file metadata with
columns "name" and "value".}

\item{direct}{A \code{\link[tibble]{tibble}} of messages with a direct
translation, as created by \code{\link[base]{stop}},
\code{\link[base]{warning}}, \code{\link[base]{message}} or
\code{\link[base]{gettext}}; its columns are described below.}

\item{countable}{A data frame of messages where the translation depends upon
a countable value, as created by \code{\link[base]{ngettext}}; its columns are
described below.}
}
\value{
An \code{\link[R6]{R6}} object of class \code{po}.
}
\description{
Creates an object of class \code{po}, for storing package translations.
}
\note{
#' The \code{direct} element of the \code{po} object has the following columns.
\describe{
\item{msgid}{Character. The untranslated (should be American English)
message.}
\item{msgstr}{Character. The translated message, or empty strings in the case
of POT files.}
\item{is_obsolete}{Logical. Is the message obsolete?}
\item{msgctxt}{List of character. Disambiguating context information to allow
multiple messages with the same ID.}
\item{translator_comments}{List of character. Comments added by the
translator, typically to explain unclear messages, or why translation choices
were made.}
\item{source_reference_comments}{List of character. Links to where the
message occured in the source, in the form "filename:line".}
\item{flags_comments}{List of character. Typically used to describe
formatting directives. R uses C-style formatting, which would imply a
"c-format" flag.  For example %%d denotes an integer, and %%s denotes a
string. "fuzzy" flags can appear when PO files are merged.}
\item{previous_string_comments}{List of character. When PO files are merged
with an updated POT file ,and a fuzzy flag is generated, the old msgid is
stored in a previous string comment.}
}

The \code{countable} element of the \code{po} object takes the same form as
the \code{direct} element, with two differences.
\describe{
\item{msgid_plural}{Character. The plural form of the untranslated message.}
\item{msgstr}{This is now a list of character (rather than character.)}
}

The \code{direct} and \code{countable} elements also have a read-only column
named \code{msgkey} that acts as a key for the message. It is generated with
\code{\link[digest]{digest}} and \code{algo = "xxhash32"} on the \code{msgid}
and \code{msgctxt} fields.
}
\references{
Much of the logic for this function was determined from reading
\url{http://pology.nedohodnik.net/doc/user/en_US/ch-poformat.html}
}
