% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/incorporate.R
\name{incorporate}
\alias{incorporate}
\title{Given an \emph{informant} object, update and incorporate table snippets}
\usage{
incorporate(informant)
}
\arguments{
\item{informant}{An informant object of class \code{ptblank_informant}.}
}
\value{
A \code{ptblank_informant} object.
}
\description{
When the \emph{informant} object has a number of snippets available (by using
\code{\link[=info_snippet]{info_snippet()}}) and the strings to use them (by using the \verb{info_*()}
functions and \verb{\{<snippet_name>\}} in the text elements), the process of
incorporating aspects of the table into the info text can occur by
using the \code{incorporate()} function. After that, the information will be fully
updated (getting the current state of table dimensions, re-rendering the
info text, etc.) and we can print the \emph{informant} object or use the
\code{\link[=get_informant_report]{get_informant_report()}} function to see the information report.
}
\section{Function ID}{

7-1
}

\examples{
if (interactive()) {

# Take the `small_table` and
# assign it to `test_table`; we'll
# modify it later
test_table <- small_table

# Generate an informant object, add
# two snippets with `info_snippet()`,
# add information with some other
# `info_*()` functions and then
# `incorporate()` the snippets into
# the info text
informant <- 
  create_informant(
    read_fn = ~ test_table,
    tbl_name = "test_table"
  ) \%>\%
  info_snippet(
    snippet_name = "row_count",
    fn = ~ . \%>\% nrow()
  ) \%>\%
  info_snippet(
    snippet_name = "col_count",
    fn = ~ . \%>\% ncol()
  ) \%>\%
  info_columns(
    columns = vars(a),
    info = "In the range of 1 to 10. (SIMPLE)"
  ) \%>\%
  info_columns(
    columns = starts_with("date"),
    info = "Time-based values (e.g., `Sys.time()`)."
  ) \%>\%
  info_columns(
    columns = "date",
    info = "The date part of `date_time`. (CALC)"
  ) \%>\%
  info_section(
    section_name = "rows",
    row_count = "There are {row_count} rows available."
  ) \%>\%
  incorporate()

# We can print the `informant` object
# to see the information report

# Let's modify `test_table` to give
# it more rows and an extra column
test_table <- 
  dplyr::bind_rows(test_table, test_table) \%>\%
  dplyr::mutate(h = a + c)

# Using `incorporate()` will cause
# the snippets to be reprocessed, and,
# the strings to be updated
informant <-
  informant \%>\% incorporate()
  
# When printed again, we'll see that the
# row and column counts in the header
# have been updated to reflect the
# changed `test_table`

}

}
\seealso{
Other Incorporate and Report: 
\code{\link{get_informant_report}()}
}
\concept{Incorporate and Report}
