% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agent_ops.R
\name{remove_tbl}
\alias{remove_tbl}
\title{Remove a data table associated with an agent}
\usage{
remove_tbl(agent)
}
\arguments{
\item{agent}{An \emph{agent} object of class \code{ptblank_agent} that is created with
\code{\link[=create_agent]{create_agent()}}.}
}
\description{
Removing an \emph{agent}'s association to a data table can be done with the
\code{remove_tbl()} function. This may be preferable when relying on a
table-reading function (settable in \code{\link[=create_agent]{create_agent()}}'s \code{read_fn} argument or
with \code{\link[=set_read_fn]{set_read_fn()}}) instead of directly using a table. If interrogating
again with \code{\link[=interrogate]{interrogate()}} then there must be either an association to a
table or a table-reading function available in the \emph{agent} (\code{\link[=set_read_fn]{set_read_fn()}}
can help in this regard if the the \code{read_fn} argument in \code{\link[=create_agent]{create_agent()}} was
left as \code{NULL} when creating the \emph{agent}).
}
