% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_creds_file.R
\name{create_creds_file}
\alias{create_creds_file}
\title{Create a file with DB access credentials}
\usage{
create_creds_file(file, dbname, host, port, user, password)
}
\arguments{
\item{file}{A file path for the credentials file to be stored on disk.}

\item{dbname}{The database name.}

\item{host}{The \code{host} name.}

\item{port}{The port number.}

\item{user}{The username for the database}

\item{password}{The password associated with the \code{user}.}
}
\description{
Creates a file containing access credentials for a database.
}
\examples{
\dontrun{
# Create a credentials file for access to
# remote databases (where the tables to be
# validated reside); place in the user's
# home directory
create_creds_file(
  file = "~/.pb_credentials",
  dbname = "********",
  host = "**************",
  port = ***,
  user = "********",
  password = "****************")
}

}
