% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_store.R
\name{tbl_source}
\alias{tbl_source}
\title{Obtain a table-prep formula from a table store}
\usage{
tbl_source(tbl, store = NULL)
}
\arguments{
\item{tbl}{The table name associated with a table-prep formula. This is part
of the table \code{store}. This table could be identified by its name (e.g.,
\code{tbl = "large_table"}) or by supplying a reference using a subset (with
\code{$}) of the \code{tbl_store} object (e.g., \code{tbl = store$large_table}). If using
the latter method then nothing needs to be supplied to \code{store}.}

\item{store}{Either a table store object created by the \code{\link[=tbl_store]{tbl_store()}}
function or a path to a table store YAML file created by \code{\link[=yaml_write]{yaml_write()}}.}
}
\value{
A table-prep formula.
}
\description{
The \code{tbl_source()} function provides a convenient means to access a
table-prep formula from either a \code{tbl_store} object or a table store YAML
file (which can be created with the \code{\link[=yaml_write]{yaml_write()}} function). A call to
\code{tbl_source()} is most useful as an input to the \code{tbl} argument of
\code{\link[=create_agent]{create_agent()}}, \code{\link[=create_informant]{create_informant()}}, or \code{\link[=set_tbl]{set_tbl()}}.

Should you need to obtain the table itself (that is generated via the
table-prep formula), then the \code{\link[=tbl_get]{tbl_get()}} function should be used for that.
}
\section{Examples}{


Let's create a \code{tbl_store} object by giving two table-prep formulas to
\code{\link[=tbl_store]{tbl_store()}}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{store <- 
  tbl_store(
    small_table_duck ~ db_tbl(
      table = small_table,
      dbname = ":memory:",
      dbtype = "duckdb"
    ),
    sml_table ~ pointblank::small_table
  )
}\if{html}{\out{</div>}}

We can pass a table-prep formula to \code{\link[=create_agent]{create_agent()}} via \code{\link[=tbl_source]{tbl_source()}}, add
some validation steps, and interrogate the table shortly thereafter.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{agent_1 <- 
  create_agent(
    tbl = ~ tbl_source("sml_table", store),
    label = "`tbl_source()` example",
    actions = action_levels(warn_at = 0.10)
  ) \%>\% 
  col_exists(columns = vars(date, date_time)) \%>\%
  interrogate()
}\if{html}{\out{</div>}}

The \code{agent_1} object can be printed to see the validation report in the
Viewer.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{agent_1
}\if{html}{\out{</div>}}

\if{html}{

\out{
<img src="https://raw.githubusercontent.com/rich-iannone/pointblank/main/images/man_tbl_source_1.png" alt="This image was generated from the first code example in the `tbl_source()` help file." style="width:100\%;">
}
}

The \code{tbl_store} object can be transformed to YAML with the \code{\link[=yaml_write]{yaml_write()}}
function. The following statement writes the \code{tbl_store.yml} file by default
(but a different name could be used with the \code{filename} argument):

\if{html}{\out{<div class="sourceCode r">}}\preformatted{yaml_write(store)
}\if{html}{\out{</div>}}

Let's modify the agent's target to point to the table labeled as
\code{"sml_table"} in the YAML representation of the \code{tbl_store}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{agent_2 <-
  agent_1 \%>\% 
  set_tbl(
    ~ tbl_source(
        tbl = "sml_table",
        store = "tbl_store.yml"
      )
  )
}\if{html}{\out{</div>}}

We can likewise write the agent to a YAML file with \code{\link[=yaml_write]{yaml_write()}} (writes to
\code{agent-sml_table.yml} by default but the \code{filename} allows for any filename
you want).

\if{html}{\out{<div class="sourceCode r">}}\preformatted{yaml_write(agent_2)
}\if{html}{\out{</div>}}

Now that both the agent and the associated table store are present as on-disk
YAML, interrogations can be done by using \code{\link[=yaml_agent_interrogate]{yaml_agent_interrogate()}}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{agent <- yaml_agent_interrogate(filename = "agent-sml_table.yml")
}\if{html}{\out{</div>}}
}

\section{Function ID}{

1-9
}

\seealso{
Other Planning and Prep: 
\code{\link{action_levels}()},
\code{\link{create_agent}()},
\code{\link{create_informant}()},
\code{\link{db_tbl}()},
\code{\link{draft_validation}()},
\code{\link{file_tbl}()},
\code{\link{scan_data}()},
\code{\link{tbl_get}()},
\code{\link{tbl_store}()},
\code{\link{validate_rmd}()}
}
\concept{Planning and Prep}
