% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_omega.R
\name{sample_omega}
\alias{sample_omega}
\title{Sample from the multivariate normal distribution using the OMEGA variance-covariance matrix to generate new sets of simulated ETAs from NONMEM output.}
\usage{
sample_omega(nmRun, n, seed)
}
\arguments{
\item{nmRun}{Root filename for the NONMEM run (e.g. "run315").}

\item{n}{Number of samples required.}

\item{seed}{Random seed.}
}
\value{
A data frame containing \code{n} samples from the multivariate normal distribution, using
the estimated NONMEM OMEGA variance-covariance matrix. This provides \code{n} sets of ETA estimates
suitable for simulation of new patients.
}
\description{
Sample from the multivariate normal distribution using the OMEGA variance-covariance matrix to generate new sets of simulated ETAs from NONMEM output.
}
\examples{
\dontrun{
 omDist <- sample_omega("run315", 5000, seed=740727)
}

}
\seealso{
NONMEM (\url{https://www.iconplc.com/innovation/nonmem/})
}
\author{
Justin Wilkins, \email{justin.wilkins@occams.com}
}
