% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/store.R
\name{relabel_samples}
\alias{relabel_samples}
\title{Relabel requested burn-in samples as adaptation}
\usage{
relabel_samples(sampler, indices, from = "burn", to = "adapt")
}
\arguments{
\item{sampler}{The pmwgs object that we are relabelling samples from}

\item{indices}{The sample iterations from burn-in to relabel}

\item{from}{The stage you want to re-label from. Default is "burn"}

\item{to}{The stage you want to relabel to. Default is "adapt"}
}
\value{
The pmwgs object with re-labelled samples
}
\description{
Given a sampler object and a vector of sample indices, relabel the given
samples to be adaptation samples. This will allow them to be used in the
calculation of the conditional distribution for efficient sampling.
}
\section{Further information}{


This should not usually be needed, however if you have a model that is slow
to fit, and upon visual inspection and/or trace analysis you determine that
during burn-in the samples had already approached the posterior distribution
then you can use this function to re-label samples from that point onwards
to be classed as adaptation samples.

This will allow them to be used in tests that check for the number of unique
samples, and in the building of the conditional distribution (which is used
for efficient sampling)

If all old samples do not match `from` then an error will be raised.
}

\examples{
new_pmwgs <- relabel_samples(sampled_forstmann, 17:21)
}
