% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kde.R
\name{kde}
\alias{kde}
\title{One-dimensional kernel density estimate}
\usage{
kde(data, n, MIN, MAX)
}
\arguments{
\item{data}{a vector of data from which the density estimate is constructed;}

\item{n}{the number of mesh points used in the uniform discretization of
the interval [MIN, MAX]; n has to be a power of two; if n is not
a power of two, then n is rounded up to the next power of two;
the default value of n is n=2 ^ 12;}

\item{MIN}{minimum of the interval [MIN, MAX] on which the density estimate
is constructed; default value: MIN = min(data) - Range / 10}

\item{MAX}{maximum of the interval [MIN, MAX] on which the density estimate
is constructed; default value: MAX = max(data) + Range / 10}
}
\value{
A \code{matrix} with two rows of length \code{n}, where the second row contains 
the density values on the mesh in the first row.
}
\description{
State-of-the-art gaussian kernel density estimator for
             one-dimensional data. The estimator does not use the commonly
             employed 'gaussian rule of thumb'. As a result, it outperforms
             many plug-in methods on multimodal densities with widely
             separated modes. This function is the cleaned-up version of 
             the code written and published by Z. I. Botev at:
             \url{http://web.maths.unsw.edu.au/~zdravkobotev/}
}
\examples{
set.seed(1)
data <- c(rnorm(10 ^ 3), rnorm(10 ^ 3) * 2 + 30)
d <- kde(data)
plot(d[1,], d[2,], type = 'l', xlab = 'x', ylab = 'density f(x)')
}
\references{
Z. I. Botev, J. F. Grotowski and D. P. Kroese,
            "Kernel Density Estimation Via Diffusion",
            Annals of Statistics, 2010, Volume 38, Number 5, Pages 2916-2957
}
