% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmml.naiveBayes.R
\name{pmml.naiveBayes}
\alias{pmml.naiveBayes}
\title{Generate the PMML representation for a naiveBayes object from the package
\pkg{e1071}.}
\usage{
\method{pmml}{naiveBayes}(
  model,
  model_name = "naiveBayes_Model",
  app_name = "SoftwareAG PMML Generator",
  description = "NaiveBayes Model",
  copyright = NULL,
  transforms = NULL,
  missing_value_replacement = NULL,
  predicted_field,
  ...
)
}
\arguments{
\item{model}{A naiveBayes object.}

\item{model_name}{A name to be given to the PMML model.}

\item{app_name}{The name of the application that generated the PMML.}

\item{description}{A descriptive text for the Header element of the PMML.}

\item{copyright}{The copyright notice for the model.}

\item{transforms}{Data transformations.}

\item{missing_value_replacement}{Value to be used as the 'missingValueReplacement'
attribute for all MiningFields.}

\item{predicted_field}{Required parameter; the name of the predicted field.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
PMML representation of the naiveBayes object.
}
\description{
Generate the PMML representation for a naiveBayes object from the package
\pkg{e1071}.
}
\details{
The PMML representation of the NaiveBayes model implements the definition as
specified by the Data Mining Group: intermediate probability values which
are less than the threshold value are replaced by the threshold value. This
is different from the prediction function of the \pkg{e1071} in which only
probability values of 0 and standard deviations of continuous variables of
with the value 0 are replaced by the threshold value. The two values will
therefore not match exactly for cases involving very small probabilities.
}
\examples{
library(e1071)

data(houseVotes84)
house <- na.omit(houseVotes84)

model <- naiveBayes(Class ~ V1 + V2 + V3, data = house, threshold = 0.003)

model_pmml <- pmml(model, dataset = house, predicted_field = "Class")
}
\references{
\itemize{
\item \href{https://CRAN.R-project.org/package=e1071}{e1071: Misc Functions of the Department of Statistics, Probability Theory Group (Formerly: E1071), TU Wien (on CRAN)}

\item A. Guazzelli, T. Jena, W. Lin, M. Zeller (2013). Extending the Naive
Bayes Model Element in PMML: Adding Support for Continuous Input Variables.
In \emph{Proceedings of the 19th ACM SIGKDD Conference on Knowledge
Discovery and Data Mining}.

}
}
\author{
Tridivesh Jena
}
