% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmml.iForest.R
\name{pmml.iForest}
\alias{pmml.iForest}
\title{Generate PMML for an iForest object from the \bold{isofor} package.}
\usage{
\method{pmml}{iForest}(
  model,
  model_name = "isolationForest_Model",
  app_name = "SoftwareAG PMML Generator",
  description = "Isolation Forest Model",
  copyright = NULL,
  transforms = NULL,
  missing_value_replacement = NULL,
  anomaly_threshold = 0.6,
  parent_invalid_value_treatment = "returnInvalid",
  child_invalid_value_treatment = "asIs",
  ...
)
}
\arguments{
\item{model}{An iForest object from package \bold{isofor}.}

\item{model_name}{A name to be given to the PMML model.}

\item{app_name}{The name of the application that generated the PMML.}

\item{description}{A descriptive text for the Header element of the PMML.}

\item{copyright}{The copyright notice for the model.}

\item{transforms}{Data transformations.}

\item{missing_value_replacement}{Value to be used as the 'missingValueReplacement'
attribute for all MiningFields.}

\item{anomaly_threshold}{Double between 0 and 1. Predicted values greater than this are classified as anomalies.}

\item{parent_invalid_value_treatment}{Invalid value treatment at the top MiningField level.}

\item{child_invalid_value_treatment}{Invalid value treatment at the model segment MiningField level.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
PMML representation of the \code{iForest} object.
}
\description{
Generate PMML for an iForest object from the \bold{isofor} package.
}
\details{
This function converts the iForest model object to the PMML format. The
PMML outputs the anomaly score as well as a boolean value indicating whether the
input is an anomaly or not. This is done by simply comparing the anomaly score with
\code{anomaly_threshold}, a parameter in the \code{pmml} function.
The iForest function automatically adds an extra level to all categorical variables,
labelled "."; this is kept in the PMML representation even though the use of this extra
factor in the predict function is unclear.
}
\examples{
\dontrun{

# Build iForest model using iris dataset. Create an isolation
# forest with 10 trees. Sample 30 data points at a time from
# the iris dataset to fit the trees.
library(isofor)
data(iris)
mod <- iForest(iris, nt = 10, phi = 30)

# Convert to PMML:
mod_pmml <- pmml(mod)
}

}
\references{
\href{https://github.com/Zelazny7/isofor}{isofor package on GitHub}
}
\seealso{
\code{\link[pmml]{pmml}}
}
\author{
Tridivesh Jena
}
