% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameterEstimationHelper.R
\name{pmh_sv}
\alias{pmh_sv}
\title{Particle Metropolis-Hastings algorithm for a stochastic volatility model
model}
\usage{
pmh_sv(y, initPar, nPart, T, nIter, stepSize)
}
\arguments{
\item{y}{Observations from the model for \eqn{t=1,...,T}.}

\item{initPar}{An inital value for the parameters 
\eqn{\theta=\{\mu,\phi,\sigma_v\}}.}

\item{nPart}{The number of particles to use in the filter.}

\item{T}{The number of observations.}

\item{nIter}{The number of iterations in the PMH algorithm.}

\item{stepSize}{The standard deviation of the Gaussian random walk proposal 
for \eqn{\theta}.}
}
\value{
The trace of the Markov chain exploring the posterior of \eqn{\theta}.
}
\description{
Estimates the parameter posterior for \eqn{\theta=\{\mu,\phi,\sigma_v\}} in 
a stochastic volatility model of the form \eqn{x_t = \mu + \phi ( x_{t-1} - 
\mu ) + \sigma_v v_t} and \eqn{y_t = \exp(x_t/2) e_t}, where \eqn{v_t} and 
\eqn{e_t} denote independent standard Gaussian random variables, i.e. 
\eqn{N(0,1)}.
}
\note{
See Section 5 in the reference for more details.
}
\examples{
\dontrun{

## Get the data
library("Quandl")
d <- Quandl("NASDAQOMX/OMXS30", start_date="2012-01-02", 
            end_date="2014-01-02", type="zoo")
y <- as.numeric(100 * diff(log(d$"Index Value")))

## Estimate the filtered state
res <- pmh_sv(y, c(0, 0.9, 0.2), nPart=500, T=500, nIter=1000, 
              stepSize=diag(c(0.05, 0.0002, 0.002)))

## Plot the estimate
par(mfrow=c(3,1))
hist(res$thhat[,1], main="", xlab=expression(mu), 
     ylab="marginal posterior", freq=FALSE)
hist(res$thhat[,2], main="", xlab=expression(phi), 
     ylab="marginal posterior", freq=FALSE)
hist(res$thhat[,3], main="", xlab=expression(sigma[v]), 
     ylab="marginal posterior", freq=FALSE)
}
}
\author{
Johan Dahlin <johan.dahlin@liu.se>
}
\references{
Dahlin, J. & Schoen, T. B. "Getting started with particle 
Metropolis-Hastings for inference in nonlinear dynamical models." 
pre-print, arXiv:1511.01707, 2015.
}
\keyword{ts}

