% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival.R
\name{fit_surv}
\alias{fit_surv}
\title{Basic survival analysis function}
\usage{
fit_surv(omicsData)
}
\arguments{
\item{omicsData}{A pmartR data object of any class, which has a `group_df` attribute that is usually created by the `group_designation()` function}
}
\value{
if fitted survival analysis object is returned
}
\description{
Implements overall survival analysis or progression-free survival analysis, depending upon the datatypes supplied to
surv_designation, and return the "survfit" object
}
\examples{
\dontshow{if (requireNamespace("pmartRdata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontrun{
library(MSomicsSTAT)
library(OvarianPepdataBP)

# Basic analysis without covariates
attr(tcga_ovarian_pepdata_bp, "survDF") <- list(t_death = "survival_time",
                                                ind_death = "vital_status")
sfit <- fit_surv(tcga_ovarian_pepdata_bp)
plot(sfit)

# Add some covariate information
attr(tcga_ovarian_pepdata_bp, "survDF") <- list(
  t_death = "survival_time",
  ind_death = "vital_status",
  covariates = "g__initial_pathologic_diagnosis_method_g1"
)
sfit <- fit_surv(tcga_ovarian_pepdata_bp)
plot(sfit, col = c(1, 2))
}
\dontshow{\}) # examplesIf}
}
