% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trelliPlots_seqData.R
\name{trelli_rnaseq_nonzero_bar}
\alias{trelli_rnaseq_nonzero_bar}
\title{Bar chart trelliscope building function for Non-Zero counts in RNA-seq data}
\usage{
trelli_rnaseq_nonzero_bar(
  trelliData,
  cognostics = c("total count", "non-zero count", "non-zero proportion"),
  proportion = TRUE,
  ggplot_params = NULL,
  interactive = FALSE,
  path = .getDownloadsFolder(),
  name = "Trelliscope",
  test_mode = FALSE,
  test_example = 1,
  single_plot = FALSE,
  ...
)
}
\arguments{
\item{trelliData}{A trelliscope data object made by as.trelliData.edata or
as.trelliData. Must be built using seqData. Required.}

\item{cognostics}{A vector of cognostic options for each plot. Defaults are "total count",
"non-zero count", and "non-zero proportion". If grouping
data is included, all cognostics will be reported per group. If the 
trelliData is paneled by a biomolecule, the counts and proportion we be 
samples. If paneled by a sample or biomolecule class, the counts and proportions
will be biomolecules.}

\item{proportion}{A logical to determine whether plots should display counts
or proportions. Default is TRUE.}

\item{ggplot_params}{An optional vector of strings of ggplot parameters to
the backend ggplot function. For example, c("ylab('')", "xlab('')").
Default is NULL.}

\item{interactive}{A logical argument indicating whether the plots should be
interactive or not. Interactive plots are ggplots piped to ggplotly (for
now). Default is FALSE.}

\item{path}{The base directory of the trelliscope application. Default is
Downloads.}

\item{name}{The name of the display. Default is Trelliscope.}

\item{test_mode}{A logical to return a smaller trelliscope to confirm plot
and design. Default is FALSE.}

\item{test_example}{A vector of plot indices to return for test_mode. Default
is 1.}

\item{single_plot}{A TRUE/FALSE to indicate whether 1 plot (not a
trelliscope) should be returned. Default is FALSE.}

\item{...}{Additional arguments to be passed on to the trelli builder}
}
\value{
No return value, builds a trelliscope display of bar charts that is stored in `path`
}
\description{
Specify a plot design and cognostics for the Non-Zero barchart
   trelliscope. Non-Zeroes are displayed per panel_by variable. Main_effects
   data is used to split samples when applicable. For MS/NMR data, use 
   "trelli missingness bar".
}
\examples{
\dontshow{if (requireNamespace("pmartRdata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontrun{
library(pmartRdata)

trelliData_seq1 <- as.trelliData.edata(e_data = rnaseq_edata, 
                                      edata_cname = "Transcript",
                                      omics_type = "seqData")
omicsData_seq <- group_designation(omicsData = rnaseq_object, main_effects = c("Virus"))

# Filter low transcript counts
omicsData_seq <- applyFilt(filter_object = total_count_filter(omicsData = omicsData_seq), 
 omicsData = omicsData_seq, min_count = 15)

# Select a normalization and statistics method (options are 'edgeR', 'DESeq2', and 'voom').
# See ?difexp_seq for more details
statRes_seq <- diffexp_seq(omicsData = omicsData_seq, method = "voom")

# Generate the trelliData object
trelliData_seq2 <- as.trelliData(omicsData = omicsData_seq)
trelliData_seq3 <- as.trelliData(statRes = statRes_seq)
trelliData_seq4 <- as.trelliData(omicsData = omicsData_seq, statRes = statRes_seq)

# Build the non-zero bar plot with an edata file. Generate trelliData in as.trelliData.edata
trelli_panel_by(trelliData = trelliData_seq1, panel = "Transcript") \%>\% 
  trelli_rnaseq_nonzero_bar(test_mode = TRUE, test_example = 1:10, path = tempdir())
trelli_panel_by(trelliData = trelliData_seq1, panel = "Sample") \%>\% 
  trelli_rnaseq_nonzero_bar(test_mode = TRUE, test_example = 1:10, 
   cognostics = "non-zero proportion", path = tempdir())

# Build the non-zero bar plot with an omicsData object. Generate trelliData in as.trelliData
trelli_panel_by(trelliData = trelliData_seq2, panel = "Transcript") \%>\% 
  trelli_rnaseq_nonzero_bar(test_mode = TRUE, test_example = 1:10, path = tempdir())

# Build the non-zero bar plot with a statRes object. Generate trelliData in as.trelliData
trelli_panel_by(trelliData = trelliData_seq3, panel = "Transcript") \%>\%
  trelli_rnaseq_nonzero_bar(test_mode = TRUE, test_example = 1:10,
                         cognostics = c("non-zero proportion"), path = tempdir())

# Build the non-zero bar plot with an omicsData and statRes object. 
# Generate trelliData in as.trelliData.
trelli_panel_by(trelliData = trelliData_seq4, panel = "Gene") \%>\%
  trelli_rnaseq_nonzero_bar(test_mode = TRUE, test_example = 1:10, path = tempdir()) 

# Or making the plot interactive 
trelli_panel_by(trelliData = trelliData_seq2, panel = "Transcript") \%>\% 
   trelli_rnaseq_nonzero_bar(test_mode = TRUE, test_example = 1:5, 
     interactive = TRUE, path = tempdir())
   
# Or visualize only count data 
trelli_panel_by(trelliData = trelliData_seq2, panel = "Transcript") \%>\% 
   trelli_rnaseq_nonzero_bar(test_mode = TRUE, test_example = 1:5, 
     cognostics = "non-zero count", proportion = FALSE, path = tempdir())

\dontshow{closeAllConnections()}   
}
\dontshow{\}) # examplesIf}
}
\author{
David Degnan, Lisa Bramer
}
