% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/applyFilt.R
\name{applyFilt}
\alias{applyFilt}
\alias{applyFilt.moleculeFilt}
\alias{applyFilt.totalCountFilt}
\alias{applyFilt.RNAFilt}
\alias{applyFilt.cvFilt}
\alias{applyFilt.rmdFilt}
\alias{applyFilt.proteomicsFilt}
\alias{applyFilt.imdanovaFilt}
\alias{applyFilt.customFilt}
\title{Apply a S3 filter object to a pmartR S3 object}
\usage{
applyFilt(filter_object, omicsData, ...)

\method{applyFilt}{moleculeFilt}(filter_object, omicsData, min_num = 2, ...)

\method{applyFilt}{totalCountFilt}(filter_object, omicsData, min_count, ...)

\method{applyFilt}{RNAFilt}(
  filter_object,
  omicsData,
  min_nonzero = NULL,
  size_library = NULL,
  ...
)

\method{applyFilt}{cvFilt}(filter_object, omicsData, cv_threshold = 150, ...)

\method{applyFilt}{rmdFilt}(
  filter_object,
  omicsData,
  pvalue_threshold = 1e-04,
  min_num_biomolecules = 50,
  ...
)

\method{applyFilt}{proteomicsFilt}(
  filter_object,
  omicsData,
  min_num_peps = NULL,
  redundancy = FALSE,
  ...
)

\method{applyFilt}{imdanovaFilt}(
  filter_object,
  omicsData,
  comparisons = NULL,
  min_nonmiss_anova = NULL,
  min_nonmiss_gtest = NULL,
  remove_singleton_groups = TRUE,
  ...
)

\method{applyFilt}{customFilt}(filter_object, omicsData, ...)
}
\arguments{
\item{filter_object}{an object of the class 'cvFilt', 'proteomicsFilt',
'rmdFilt', 'moleculeFilt', 'imdanovaFilt', 'customFilt', 'RNAFilt', or
'totalCountFilt' created by \code{cv_filter}, \code{proteomics_filter},
\code{rmd_filter}, \code{molecule_filter}, \code{imdanova_filter},
\code{custom_filter}, \code{RNA_filter}, or \code{total_count_filter},
respectively.}

\item{omicsData}{an object of the class \code{pepData}, \code{proData},
\code{lipidData}, \code{metabData}, \code{nmrData}, or \code{seqData}
usually created by \code{\link{as.pepData}}, \code{\link{as.proData}},
\code{\link{as.lipidData}}, \code{\link{as.metabData}},
\code{\link{as.nmrData}}, or \code{\link{as.seqData}}, respectively.}

\item{...}{further arguments}

\item{min_num, min_count, min_nonzero, size_library, cv_threshold, pvalue_threshold, min_num_biomolecules, min_num_peps, redundancy, comparisons, min_nonmiss_anova, min_nonmiss_gtest, remove_singleton_groups}{Arguments that depend on the class of \code{filter_object}, see details.}
}
\value{
An object of the class \code{pepData}, \code{proData},
  \code{lipidData}, \code{metabData}, \code{nmrData}, or \code{seqData} with
  specified cname_ids, edata_cnames, and emeta_cnames filtered out of the
  appropriate datasets.
}
\description{
This function takes a filter object of class 'cvFilt', 'rmdFilt',
  'moleculeFilt', 'proteomicsFilt', 'imdanovaFilt', 'RNAFilt', 'totalCountFilt',
  or 'customFilt' and  applies the filter to a dataset of \code{pepData},
  \code{proData}, \code{lipidData}, \code{metabData}, \code{nmrData} or
  \code{seqData}.
}
\details{
Further arguments can be specified depending on the class of the
  \code{filter_object} being applied.

  For a \code{filter_object} of type 'moleculeFilt': \tabular{ll}{
  \code{min_num} \tab an integer value specifying the minimum number of times
  each biomolecule must be observed across all samples in order to retain the
  biomolecule. Default value is 2. \cr }

  For a \code{filter_object} of type 'cvFilt': \tabular{ll}{
  \code{cv_threshold} \tab an integer value specifying the maximum
  coefficient of variation (CV) threshold for the biomolecules. Biomolecules
  with CV greater than this threshold will be filtered. Default threshold is
  150. \cr }

  For a \code{filter_object} of type 'rmdFilt': \tabular{ll}{
  \code{pvalue_threshold} \tab numeric value between 0 and 1, specifying the
  p-value below which samples will be removed from the dataset. Default is
  0.001. \cr \code{min_num_biomolecules} \tab numeric value greater than 10
  (preferably greater than 50) that specifies the minimum number of
  biomolecules that must be present in order to create an rmdFilt object.
  Using values less than 50 is not advised. \cr }

  For a \code{filter_object} of type 'proteomicsFilt' either or both of the
  following can be applied: \tabular{ll}{ \code{min_num_peps} \tab an
  optional integer value between 1 and the maximum number of peptides that
  map to a protein in omicsData. The value specifies the minimum number of
  peptides that must map to a protein. Any protein with less than
  \code{min_num_peps} mapping to it will be removed from the dataset. Default
  value is NULL, meaning that this filter is not applied. \cr
  \code{redundancy} \tab logical indicator of whether to filter out
  degenerate/redundant peptides (peptides that map to more than one protein).
  Default value is FALSE. \cr }

  For a \code{filter_object} of type 'imdanovaFilt': \tabular{ll}{
  \code{min_nonmiss_anova} \tab integer value specifying the minimum number
  of non-missing feature values allowed per group for \code{anova_filter}.
  Default value is 2. \cr \code{min_nonmiss_gtest} \tab integer value
  specifying the minimum number of non-missing feature values allowed per
  group for \code{gtest_filter}. Default value is 3.\cr }

  For a \code{filter_object} of type 'totalCountFilt': \tabular{ll}{
  \code{min_count} \tab integer value specifying the minimum number of
  biomolecule counts observed across all samples in order for the biomolecule
  to be retained in the dataset. This filter is only applicable for
  \code{seqData} objects. \cr }

  For a \code{filter_object} of type 'RNAFilt' either or both of the
  following can be applied: \tabular{ll}{ \code{min_nonzero} \tab integer
  value specifying the minimum number of non-zero feature values per sample.
  \cr \code{size_library} \tab integer value or fraction between 0 and 1
  specifying the minimum number of total reads per sample. This filter is
  only applicable for \code{seqData} objects. \cr }

  There are no further arguments for a \code{filter_object} of type '
  customFilt'.
}
\examples{
\dontshow{if (requireNamespace("pmartRdata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(pmartRdata)
to_filter <- molecule_filter(omicsData = pep_object)
summary(to_filter, min_num = 2)
pep_object2 <- applyFilt(
  filter_object = to_filter,
  omicsData = pep_object, min_num = 2
)
summary(pep_object2) # number of Peptides is as expected based on summary of 
                     # the filter object that was applied
pep_object2 <- group_designation(omicsData = pep_object2,
                                 main_effects = "Phenotype")
to_filter2 <- imdanova_filter(omicsData = pep_object2)
pep_object3 <- applyFilt(
  filter_object = to_filter2,
  omicsData = pep_object2,
  min_nonmiss_anova = 3
)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link{molecule_filter}}

\code{\link{imdanova_filter}}

\code{\link{rmd_filter}}

\code{\link{cv_filter}}

\code{\link{proteomics_filter}}

\code{\link{custom_filter}}

\code{\link{RNA_filter}}

\code{\link{total_count_filter}}
}
\author{
Lisa Bramer, Kelly Stratton
}
