% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trelliPlots.R
\name{trelli_foldchange_bar}
\alias{trelli_foldchange_bar}
\title{Bar chart trelliscope building function for fold_change}
\usage{
trelli_foldchange_bar(
  trelliData,
  cognostics = c("fold change", "anova p-value"),
  p_value_thresh = 0.05,
  ggplot_params = NULL,
  interactive = FALSE,
  path = .getDownloadsFolder(),
  name = "Trelliscope",
  test_mode = FALSE,
  test_example = 1,
  single_plot = FALSE,
  ...
)
}
\arguments{
\item{trelliData}{A trelliscope data object with statRes results. Required.}

\item{cognostics}{A vector of cognostic options for each plot. Valid entries
and the defaults are "fold change" and "anova p-value".}

\item{p_value_thresh}{A value between 0 and 1 to indicate significant
biomolecules for p_value_test. Default is 0.05.}

\item{ggplot_params}{An optional vector of strings of ggplot parameters to
the backend ggplot function. For example, c("ylab('')", "xlab('')").
Default is NULL.}

\item{interactive}{A logical argument indicating whether the plots should be
interactive or not. Interactive plots are ggplots piped to ggplotly (for
now). Default is FALSE.}

\item{path}{The base directory of the trelliscope application. Default is
Downloads.}

\item{name}{The name of the display. Default is Trelliscope.}

\item{test_mode}{A logical to return a smaller trelliscope to confirm plot
and design. Default is FALSE.}

\item{test_example}{A vector of plot indices to return for test_mode. Default
is 1.}

\item{single_plot}{A TRUE/FALSE to indicate whether 1 plot (not a
trelliscope) should be returned. Default is FALSE.}

\item{...}{Additional arguments to be passed on to the trelli builder}
}
\value{
No return value, builds a trelliscope display of fold_change bar plots that is stored in `path`
}
\description{
Specify a plot design and cognostics for the fold_change
  barchart trelliscope. Fold change must be grouped by edata_cname.
}
\examples{
\dontshow{if (requireNamespace("pmartRdata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
library(pmartRdata)

# Transform the data
omicsData <- edata_transform(omicsData = pep_object, data_scale = "log2")

# Group the data by condition
omicsData <- group_designation(omicsData = omicsData, main_effects = c("Phenotype"))

# Apply the IMD ANOVA filter
imdanova_Filt <- imdanova_filter(omicsData = omicsData)
omicsData <- applyFilt(filter_object = imdanova_Filt, omicsData = omicsData,
                       min_nonmiss_anova = 2)

# Normalize my pepData
omicsData <- normalize_global(omicsData, "subset_fn" = "all", "norm_fn" = "median",
                             "apply_norm" = TRUE, "backtransform" = TRUE)

# Implement the IMD ANOVA method and compute all pairwise comparisons 
# (i.e. leave the `comparisons` argument NULL)
statRes <- imd_anova(omicsData = omicsData, test_method = 'combined')

# Generate the trelliData object
trelliData3 <- as.trelliData(statRes = statRes)
trelliData4 <- as.trelliData(omicsData = omicsData, statRes = statRes)

# Build fold_change bar plot with statRes data grouped by edata_colname.
trelli_panel_by(trelliData = trelliData3, panel = "Peptide") \%>\% 
  trelli_foldchange_bar(test_mode = TRUE, test_example = 1:10, path = tempdir())

\dontshow{closeAllConnections()}
}
\dontshow{\}) # examplesIf}
}
\author{
David Degnan, Lisa Bramer
}
