% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_or.R
\name{plot_or}
\alias{plot_or}
\title{Plot OR}
\usage{
plot_or(glm_model_results, conf_level = 0.95, confint_fast_estimate = FALSE)
}
\arguments{
\item{glm_model_results}{Results from a binomial Generalised Linear Model (GLM), as produced by \code{\link[stats:glm]{stats::glm()}}.}

\item{conf_level}{Numeric between 0.001 and 0.999 (default = 0.95). The confidence level to use when setting the confidence interval, most commonly will be 0.95 or 0.99 but can be set otherwise.}

\item{confint_fast_estimate}{Boolean (default = \code{FALSE}) Should a faster estimate of the confidence interval be used? IMPORTANT, setting this to \code{TRUE} assumes normally distributed data, which may not be appropriate for your data.}
}
\value{
an object of class \code{gg} and \code{ggplot}
}
\description{
Produces an Odds Ratio plot to visualise the results of a logistic regression analysis.
}
\examples{
# libraries
library(plotor)
library(datasets)
library(dplyr)
library(ggplot2)
library(stats)
library(forcats)
library(tidyr)

# get some data
df <- datasets::Titanic |>
  as_tibble() |>
  # convert aggregated counts to individual observations
  filter(n > 0) |>
  uncount(weights = n) |>
  # convert character variables to factors
  mutate(across(where(is.character), as.factor))

# perform logistic regression using `glm`
lr <- glm(
  data = df,
  family = 'binomial',
  formula = Survived ~ Class + Sex + Age
)

# produce the Odds Ratio plot
plot_or(lr)
}
\seealso{
See vignette('using_plotor', package = 'plotor') for more details on use.

More details and examples are found on the website: \url{https://craig-parylo.github.io/plotor/index.html}
}
