% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplotly.R
\name{gg2list}
\alias{gg2list}
\title{Convert a ggplot to a list.}
\usage{
gg2list(p, width = NULL, height = NULL, tooltip = "all",
  dynamicTicks = FALSE, layerData = 1, originalData = TRUE,
  source = "A", ...)
}
\arguments{
\item{p}{ggplot2 plot.}

\item{width}{Width of the plot in pixels (optional, defaults to automatic sizing).}

\item{height}{Height of the plot in pixels (optional, defaults to automatic sizing).}

\item{tooltip}{a character vector specifying which aesthetic tooltips to show in the
tooltip. The default, "all", means show all the aesthetic tooltips
(including the unofficial "text" aesthetic).}

\item{dynamicTicks}{accepts the following values: \code{FALSE}, \code{TRUE}, \code{"x"}, or \code{"y"}.
Dynamic ticks are useful for updating ticks in response to zoom/pan/filter
interactions; however, there is no guarantee they reproduce axis tick text 
as they would appear in the static ggplot2 image.}

\item{layerData}{data from which layer should be returned?}

\item{originalData}{should the "original" or "scaled" data be returned?}

\item{source}{a character string of length 1. Match the value of this string 
with the source argument in \code{\link{event_data}()} to retrieve the 
event data corresponding to a specific plot (shiny apps can have multiple plots).}

\item{...}{currently not used}
}
\value{
a 'built' plotly object (list with names "data" and "layout").
}
\description{
Convert a ggplot to a list.
}
