% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image_modify_local.R
\name{image_modify_local}
\alias{image_modify_local}
\title{Modify Only a Subregion of an Image}
\usage{
image_modify_local(x, FUN, geometry = "click", local = "local", ...)
}
\arguments{
\item{x}{an image read into R by 
\code{magick::image_read} or an image  
modified by functions in the magick 
package.}

\item{FUN}{the function used to 
modify \code{x}. NOTE: the result 
of \code{FUN} must be of the same 
class as \code{x} and its width and 
height must not be changed during 
modification.}

\item{geometry}{this parameter is 
different from the one used in package 
magick. Here, in this function, you can 
set \code{geometry = "click"} if you want 
to show which part you want to modify 
by mouse click (see 
function \code{image_crop_click} for how to 
use mouse click). Otherwise, you can use 
a length 4 vector with the exact order: left, 
right, top, bottom.}

\item{local}{if it is 1 or "local", only a subregion 
of your image will be modified. If it is 2
or "other", keep the subregion unchanged while 
modifying other parts. If it is 3 or "subregion", 
the result is only the modified subregion, not the 
whole image.}

\item{..., }{extra parameters used by 
\code{FUN}.}
}
\description{
The function allows you to modify a subregion  
of your image (or, the opposite, keep the 
subregion unchanged while modifying other parts).
You can set the four sides of the subregion by 
mouse click.
}
