% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{fill_area}
\alias{fill_area}
\title{Utility function}
\usage{
fill_area(x, y, from = 0, col = "black", alpha = 0.25, border = NA,
  na.rm = TRUE, horiz = TRUE, outline = FALSE, ...)
}
\arguments{
\item{x}{Vector with values on x-axis.}

\item{y}{Vector with values on y-axis.}

\item{from}{A number indicating until which value on the y-axis the graph 
is colored. Defaults to 0.}

\item{col}{Color for filling the area. Default is black.}

\item{alpha}{Transparency of shaded area. Number between 0 
(completely transparent) and 1 (not transparent). Default is .25.}

\item{border}{A color, indicating the color of the border around 
shaded area. No border with value NA (default).}

\item{na.rm}{Logical: whether or not to remove the missing values in 
\code{x} and \code{y}. Defaults to TRUE. If set to FALSE, missing values 
may cause that the filled area is split in various smaller areas.}

\item{horiz}{Logical: whether or not to plot with respect to the 
x-axis (TRUE) or y-xis (FALSE). Defaults to TRUE.}

\item{outline}{Logical: whether or not to draw the outline instead of only 
the upper border of the shape. Default is FALSE (no complete outline).}

\item{...}{Optional arguments for the lines. See \code{\link{par}}.}
}
\description{
Fill area under line or plot.
}
\examples{
# density of a random sample from normal distribution:
test <- density(rnorm(1000))
emptyPlot(range(test$x), range(test$y))
fill_area(test$x, test$y)
fill_area(test$x, test$y, from=.1, col='red')
fill_area(test$x, test$y, from=.2, col='blue', density=10, lwd=3)
lines(test$x, test$y, lwd=2)

}
\seealso{
\code{\link{check_normaldist}}

Other Functions for plotting: \code{\link{addInterval}},
  \code{\link{add_bars}}, \code{\link{add_n_points}},
  \code{\link{alphaPalette}}, \code{\link{alpha}},
  \code{\link{check_normaldist}},
  \code{\link{color_contour}}, \code{\link{dotplot_error}},
  \code{\link{drawDevArrows}}, \code{\link{emptyPlot}},
  \code{\link{errorBars}}, \code{\link{getCoords}},
  \code{\link{getFigCoords}}, \code{\link{getProps}},
  \code{\link{gradientLegend}},
  \code{\link{legend_margin}},
  \code{\link{marginDensityPlot}},
  \code{\link{plot_error}}, \code{\link{plot_image}},
  \code{\link{plotsurface}}, \code{\link{sortBoxplot}}
}
\author{
Jacolien van Rij
}
