% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{drawArrows}
\alias{drawArrows}
\title{Draw arrows between different plots.}
\usage{
drawArrows(pos0, pos1, type = 1, plot = TRUE, ...)
}
\arguments{
\item{pos0}{2-number vector with x and y coordinate of start position. 
Could be defined in coordinates (default), proportions of the plot region, 
or proportions of the figure. See \code{input}.}

\item{pos1}{2-number vector with x and y coordinate of end position. 
Could be defined in coordinates (default), proportions of the plot region, 
or proportions of the figure. See \code{input}.}

\item{type}{Type of coordinates provided: type=1 is coordinates with 
respect to the x- and y-axis; type=2 is proportions with respect to the 
x- and y-axis, with proportions > 1 or < 0 falling outside the plot 
region; type=3 is proportions with respect to the figure region, with 
proportions > 1 or < 0 falling outside the figure window. See examples 
for arrows crossing figure borders.}

\item{plot}{Logical: whether or not to plot the arrow. 
Might be useful for calculating arrow parts in advance.}

\item{...}{graphical parameters and parameters provided for 
\code{\link[graphics]{arrows}}.}
}
\value{
The function outputs the proportions with respect to the figure 
window for the start point and the end point.
}
\description{
Function for positioning a legend or label in or outside the 
plot region based on proportion of the plot region rather than Cartesian 
coordinates.
}
\section{Notes}{

\itemize{
\item For drawing lines or arrows through different plots the order of the plot 
is crucial. See the example 1 below. 
\item The function assumes that the different figure windows have the same size. 
See example 2 below for the use of layout and different sized figure 
windows.
}
}
\examples{

### EXAMPLE 1 ################################

# setup 4 plots:
par(mfrow=c(2,2))

# add first plot:
plot(0.5, 0.5, pch="1")

# add arrow from plot 1 to plot 3, using plot coordinates:
a <- drawArrows(pos0=c(0.5, .5), pos1=c(0.5, -.5), code=2, 
   col='blue', lwd=2)
# add arrow from plot 1 to plot 2, using plot proportions:
b <- drawArrows(pos0=c(1, .5), pos1=c(2, 1), type=2, code=2, 
   col='red', lwd=2, lty=3)
# add arrow from plot 1 to plot 4, using figure proportions, end in plot 1:
c <- drawArrows(pos0=c(.9,.1), pos1=c(1.25, -0.25), type=3, 
   code=1, col='green', lwd=2, lty=5)

# add second plot, with different coordinates:
plot(c(-2.33, 20), c(.3, .8), type='n', main='2')
# finish arrow b:
p0 <- b$pos0[['right']]
p1 <- b$pos1[['right']]
# note that we have to set type=3, because output is figure proportions:
drawArrows(pos0=p0, pos1=p1, code=2, col='red', lwd=2, lty=3, type=3)

# start arrow from plot 2 to plot 3:
# combine plot proportions (middle of x-axis) with figure proportions
# (center of new figure) 
d <- drawArrows(pos0=getProps(getCoords(c(.5,0), side=c(1,2)), 
        side=c(1,2), output="f"), 
    pos1=c(-.25,-.25), type=3, code=2, lwd=2)

# add third plot, with different coordinates:
plot(c(25, 20), c(7,-7), type='n', main='3')

# finish arrow a:
p0 <- a$pos0[['bottom']]
p1 <- a$pos1[['bottom']]
drawArrows(pos0=p0, pos1=p1, type=3, code=2, col='blue', lwd=2)

# continue arrow c
p0 <- c$pos0[['bottom']]
p1 <- c$pos1[['bottom']]
# note that we could save the output as a new list:
cnew <- drawArrows(pos0=p0, pos1=p1, type=3, code=0, 
   col='green', lwd=2, lty=5)

# finish arrow d
p0 <- d$pos0[['bottomleft']]
p1 <- d$pos1[['bottomleft']]
# now we see that a part of the arrow is missing:
drawArrows(pos0=p0, pos1=p1, code=2, lwd=2, type=3)

# add fourth plot:
plot(c(25, 20), c(7,-7), type='n', main='4')

# finish arrow c using the new variable cnew:
p0 <- cnew$pos0[['right']]
p1 <- cnew$pos1[['right']]
drawArrows(pos0=p0, pos1=p1, code=0, col='green', lwd=2, lty=5, type=3)
# ... or we could finish arrow c using the old variable c:
p0 <- c$pos0[['bottomright']]
p1 <- c$pos1[['bottomright']]
drawArrows(pos0=p0, pos1=p1, code=0, col='darkgreen', lwd=2,type=3)

# finish arrow d:
p0 <- d$pos0[['bottom']]
p1 <- d$pos1[['bottom']]
drawArrows(pos0=p0, pos1=p1, code=2, lwd=2, type=3)


### EXAMPLE 2 ################################

layout(matrix(c(1,3,2,2), byrow=FALSE, ncol=2))
layout.show(3)

# plot 1:
plot(1,1, type='n', main='1')
a <- drawArrows(pos0=c(.5,.5), pos1=c(1.5, 0), type=3, code=1, 
   col='green', lwd=2, lty=5)

plot(1,1, type='n', main='2')
# this will result in incorrect continuation of the error, 
# because the proportion method assumes the same size of 
# figure windows:
p0 <- a$pos0[['right']]
p1 <- a$pos1[['right']]
drawArrows(pos0=p0, pos1=p1, type=3, code=0, col='red', lwd=2, 
   lty=5)

# as the window is twice as high, we could adjust y-position
# to fix this:
p0[2] <- p0[2]/2+.5
p1[2] <- p1[2]/2+.5
drawArrows(pos0=p0, pos1=p1, type=3, code=0, col='darkgreen', 
   lwd=2, lty=3)


### EXAMPLE 3 ################################
# Differences between three types

par(mfrow=c(1,2))

# add first plot:
par(mar=c(6,6,6,6))
plot(0.75, 0.75, pch="1")

# TYPE 1:
a <- drawArrows(pos0=c(.8, .5), pos1=c(2, .6), type=1, code=2, 
   col='red', lwd=2, lty=3)
# TYPE 2:
b <- drawArrows(pos0=c(.8, .5), pos1=c(2, .6), type=2, code=2, 
   col='green', lwd=2, lty=3)
# TYPE 3:
c <- drawArrows(pos0=c(.8, .5), pos1=c(2, .6), type=3, code=2, 
   col='blue', lwd=2, lty=5)

# add second plot:
par(mar=c(3,1,1,1))
plot(0.95, 0.95, pch="2")
# finish arrow a:
p0 <- a$pos0[['right']]
p1 <- a$pos1[['right']]
drawArrows(pos0=p0, pos1=p1, type=3, code=2, col='red', lwd=2, lty=3)
# finish arrow b:
p0 <- b$pos0[['right']]
p1 <- b$pos1[['right']]
drawArrows(pos0=p0, pos1=p1, type=3, code=2, col='green', lwd=2, lty=3)
# finish arrow c:
p0 <- c$pos0[['right']]
p1 <- c$pos1[['right']]
drawArrows(pos0=p0, pos1=p1, type=3, code=2, col='blue', lwd=2, lty=5)

}
\author{
Jacolien van Rij
}
\seealso{
Other Functions for plotting: \code{\link{addInterval}},
  \code{\link{add_bars}}, \code{\link{add_n_points}},
  \code{\link{alphaPalette}}, \code{\link{alpha}},
  \code{\link{check_normaldist}},
  \code{\link{color_contour}}, \code{\link{dotplot_error}},
  \code{\link{emptyPlot}}, \code{\link{errorBars}},
  \code{\link{fill_area}}, \code{\link{getCoords}},
  \code{\link{getFigCoords}}, \code{\link{getProps}},
  \code{\link{gradientLegend}},
  \code{\link{legend_margin}},
  \code{\link{marginDensityPlot}},
  \code{\link{plot_error}}, \code{\link{plot_image}},
  \code{\link{plotsurface}}
}

