% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plmm_checks.R
\name{plmm_checks}
\alias{plmm_checks}
\title{plmm_checks}
\usage{
plmm_checks(
  design,
  K = NULL,
  diag_K = NULL,
  eta_star = NULL,
  penalty = "lasso",
  init = NULL,
  gamma,
  alpha = 1,
  trace = FALSE,
  save_rds = NULL,
  return_fit = TRUE,
  ...
)
}
\arguments{
\item{design}{The design object, as created by \code{create_design()}}

\item{K}{Similarity matrix used to rotate the data. This should either be (1) a known matrix that reflects the covariance of y, (2) an estimate (Default is \eqn{\frac{1}{p}(XX^T)}), or (3) a list with components 'd' and 'u', as returned by choose_k().}

\item{diag_K}{Logical: should K be a diagonal matrix? This would reflect observations that are unrelated, or that can be treated as unrelated. Defaults to FALSE.
Note: plmm() does not check to see if a matrix is diagonal. If you want to use a diagonal K matrix, you must set diag_K = TRUE.}

\item{eta_star}{Optional argument to input a specific eta term rather than estimate it from the data. If K is a known covariance matrix that is full rank, this should be 1.}

\item{penalty}{The penalty to be applied to the model. Either "MCP" (the default), "SCAD", or "lasso".}

\item{init}{Initial values for coefficients. Default is 0 for all columns of X.}

\item{gamma}{The tuning parameter of the MCP/SCAD penalty (see details). Default is 3 for MCP and 3.7 for SCAD.}

\item{alpha}{Tuning parameter for the Mnet estimator which controls the relative contributions from the MCP/SCAD penalty and the ridge, or L2 penalty. alpha=1 is equivalent to MCP/SCAD penalty, while alpha=0 would be equivalent to ridge regression. However, alpha=0 is not supported; alpha may be arbitrarily small, but not exactly 0.}

\item{trace}{If set to TRUE, inform the user of progress by announcing the beginning of each step of the modeling process. Default is FALSE.}

\item{save_rds}{Optional: if a filepath and name is specified (e.g., \code{save_rds = "~/dir/my_results.rds"}), then the model results are saved to the provided location. Defaults to NULL, which does not save the result.}

\item{return_fit}{Optional: a logical value indicating whether the fitted model should be returned as a \code{plmm} object in the current (assumed interactive) session. Defaults to TRUE.}

\item{...}{Additional arguments to \code{get_data()}}
}
\value{
A list of parameters to pass on to model fitting. The list includes the standardized design matrix, the outcome, and meta-data
}
\description{
plmm_checks
}
\keyword{internal}
