% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_mosaic.R
\name{mosaic_vectorize}
\alias{mosaic_vectorize}
\title{Vectorize a \code{SpatRaster} mask to an \code{sf} object}
\usage{
mosaic_vectorize(
  mask,
  aggregate = NULL,
  watershed = TRUE,
  tolerance = 1,
  extension = 1,
  opening = FALSE,
  closing = FALSE,
  filter = FALSE,
  erode = FALSE,
  dilate = FALSE,
  fill_hull = FALSE,
  lower_size = NULL,
  upper_size = NULL,
  topn_lower = NULL,
  topn_upper = NULL
)
}
\arguments{
\item{mask}{An optional mask (SpatRaster) to mask the mosaic.}

\item{aggregate}{The size as a fraction (percentage) of the input image size.
Either a scalar (eg., 50), or a length-two numeric vector. In the last,
different percentage reduction/expansion can be used for columns, and rows,
respectively.}

\item{watershed}{If \code{TRUE} (default), performs watershed-based object
detection. This will detect objects even when they are touching one another.
If FALSE, all pixels for each connected set of foreground pixels are set to
a unique object. This is faster but is not able to segment touching
objects.}

\item{tolerance}{The minimum height of the object in the units of image
intensity between its highest point (seed) and the point where it contacts
another object (checked for every contact pixel). If the height is smaller
than the tolerance, the object will be combined with one of its neighbors,
which is the highest.}

\item{extension}{Radius of the neighborhood in pixels for the detection of
neighboring objects. A higher value smooths out small objects.}

\item{opening, closing, filter, erode, dilate}{\strong{Morphological operations (brush size)}
\itemize{
\item \code{dilate} puts the mask over every background pixel, and sets it to
foreground if any of the pixels covered by the mask is from the foreground.
\item \code{erode} puts the mask over every foreground pixel, and sets it to
background if any of the pixels covered by the mask is from the background.
\item \code{opening} performs an erosion followed by a dilation. This helps to
remove small objects while preserving the shape and size of larger objects.
\item \code{closing} performs a dilatation followed by an erosion. This helps to
fill small holes while preserving the shape and size of larger objects.
\item \code{filter} performs median filtering in the binary image. Provide a positive
integer > 1 to indicate the size of the median filtering. Higher values are
more efficient to remove noise in the background but can dramatically impact
the perimeter of objects, mainly for irregular perimeters such as leaves
with serrated edges.
}}

\item{fill_hull}{Fill holes in the binary image? Defaults to \code{FALSE}.}

\item{lower_size, upper_size}{Lower and upper limits for size for the image
analysis. Plant images often contain dirt and dust.  Upper limit is set to
\code{NULL}, i.e., no upper limit used. One can set a known area or use
\code{lower_size = 0} to select all objects (not advised). Objects that matches
the size of a given range of sizes can be selected by setting up the two
arguments. For example, if \code{lower_size = 120} and \code{upper_size = 140},
objects with size greater than or equal 120 and less than or equal 140 will
be considered.}

\item{topn_lower, topn_upper}{Select the top \code{n} objects based on its area.
\code{topn_lower} selects the \code{n} elements with the smallest area whereas
\code{topn_upper} selects the \code{n} objects with the largest area.}
}
\value{
An \code{sf} object containing vectorized features from the raster mask,
with added area measurements.
}
\description{
Converts a raster mask into a vectorized \code{sf} object, with various options
for morphological operations and filtering.
}
\examples{
if (interactive() && requireNamespace("EBImage")) {
library(pliman)
mask <- image_pliman("mask.tif")
shp <- mosaic_vectorize(mask, watershed = FALSE)
mosaic_plot(mask)
shapefile_plot(shp, add = TRUE, lwd = 3)
}


}
