\name{propagate.GP}
\alias{propagate.GP}
\alias{propagate.CGP}
\alias{propagate.ConstGP}

\title{
  PL propagate rule for GPs
}
\description{
  Incorporation of a new data point for Gaussian process (GP)
  regression, classification, or combined unknown constraint
  models; primarily to be used particle learning (PL)
  propagate step
}
\usage{
propagate.GP(z, Zt, prior)
propagate.CGP(z, Zt, prior)
propagate.ConstGP(z, Zt, prior)
}
\arguments{
  \item{z}{
    new observation whose to be incorporate into the
    particle \code{Zt}
  }
  \item{Zt}{
    the particle describing model parameters and sufficient statistics
    that the new data is being incorporated into
  }
  \item{prior}{
    prior parameters passed from \code{\link{PL}} generated by one of
    the prior functions, e.g., \code{\link{prior.GP}}
  }
}
\details{
  This is the workhorse of the \code{\link{PL}} propagate step.
  After re-sampling the particles, \code{\link{PL}} calls
  \code{propagate} on each of the particles to obtain the set used in
  the next round/time-step

  The \code{\link{propagate.ConstGP}} is essentially the combination
  of \code{\link{propagate.GP}} and \code{\link{propagate.CGP}}
  for regression and classification GP models, respectively
}
\value{
  These functions return a new particle with the new observation
  incorporated
}
\references{

 Gramacy, R. and Polson, N. (2011).
  \dQuote{Particle learning of Gaussian process models for
    sequential design and optimization.}
  Journal of Computational and Graphical Statistics, 20(1), 
  pp. 102-118; arXiv:0909.5262

  Gramacy, R. and Lee, H. (2010).
  \dQuote{Optimization under unknown constraints}.
  \emph{Bayesian Statistics 9}, J. M. Bernardo, M. J. Bayarri,
  J. O. Berger, A. P. Dawid, D. Heckerman, A. F. M. Smith and M. West
  (Eds.); Oxford University Press

  Gramacy, R. (2020).
  \dQuote{Surrogates: Gaussian Process Modeling, Design and Optimization for the Applied Sciences}.
  Chapman Hall/CRC; \url{https://bobby.gramacy.com/surrogates/}

  \url{https://bobby.gramacy.com/r_packages/plgp/}
}
\author{
Robert B. Gramacy, \email{rbg@vt.edu}
}
\seealso{
 \code{\link{PL}}, \code{\link{lpredprob.GP}}
}
\examples{
## See the demos via demo(package="plgp") and the examples
## section of ?plgp
}

\keyword{models}
\keyword{regression}
\keyword{classif}
\keyword{methods}
