\name{latticistCompose}
\alias{latticistCompose}
\alias{latticistParse}
\alias{try.prepanel.loess}
\alias{n.level.colors}
\alias{simpleColorKey}
\title{ Latticist API }
\description{
  Convert a simple specification list into a Lattice plot call,
  or the inverse operation.
}
\usage{
latticistCompose(dat, spec = alist(),
                 datArg = substitute(dat))

latticistParse(call, trellis = NULL)
}
\arguments{
  \item{dat}{
    a data frame (with numeric and/or categorical variables).
  }
  \item{datArg}{
    the symbol to use for \code{dat} in the generated call.
  }
  \item{spec}{
    a list specifying the latticist plot. See Details.
  }
  \item{call}{ a call to a high-level lattice plot function. }
  \item{trellis}{ the trellis object generated by \code{call}; optional. }
}
\details{

  Elements of \code{spec} can include:
  \describe{
    \item{\code{xvar, yvar, zvar}}{
      variables (or expressions) for the x, y and z axes.
      If all are missing, a hypervariate plot is produced according to
      \code{defaultPlot} (below).
    }
    \item{\code{groups}}{
      a grouping variable or color-coding covariate (can be categorical
      or numeric).
    }
    \item{\code{cond, cond2}}{
      conditioning variables.
    }
    \item{\code{subset}}{
      subset expression.
    }
    \item{\code{varSubset}}{
      the subset of variables (from the data frame, \code{dat}) to
      include in hypervariate plots (see defaultPlot).
    }
    \item{\code{defaultPlot}}{
      one of "marginal.plot" (the default), "splom" or
      "parallel". Specifies the type of plot to produce when xvar and yvar
      are missing.
    }
    \item{etc}{ TODO... }
  }

  Note that xvar, yvar, zvar, groups, cond, cond2, subset must be
  language objects. The easiest way to specify them is to use the
  \code{alist()} structure, or equivalently to wrap each element in
  \code{quote()}; see examples.
}
\value{
  \code{latticistCompose} returns a call.

  \code{latticistParse} returns a list, in the same form as \code{spec}.
}
\author{ Felix Andrews \email{felix@nfrac.org} }
\references{
  For an excellent introduction to and coverage of Lattice:

Sarkar, Deepayan (2008) "Lattice: Multivariate Data Visualization with
R", Springer. \url{http://lmdvr.r-forge.r-project.org/}
}
\seealso{
  \code{\link{latticist}},
  \link[lattice]{Lattice}
}
\examples{

latticistCompose(CO2)

latticistCompose(CO2, spec = alist(xvar = uptake))

latticistCompose(CO2, spec = alist(yvar = uptake))

latticistCompose(CO2, spec = alist(yvar = uptake, ydisc = TRUE))

latticistParse(quote(xyplot(conc ~ uptake | Type, CO2,
                            type = "p")))

}
\keyword{ hplot }
