% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drive_time.R
\name{drive_time}
\alias{drive_time}
\title{Get travel time and distance between two point using the Google API.}
\usage{
drive_time(address, dest, auth = "standard_api", privkey = NULL,
  clientid = NULL, clean = "TRUE", travel_mode = "driving",
  units = "metric", verbose = FALSE, add_date = "none",
  language = "en-EN", messages = FALSE, small = FALSE)
}
\arguments{
\item{address}{A 1xN vector of locations. These may be either (1) latitude and longitude coordinates
(formatted as "lat,long" with no spaces) or physical addresses that contain "url-safe" UTF-8 characters.
Enabling the "clean" parameter (see below) attempts to strip or replace common character patterns
from the input that are incompatible with the Google Maps API using the \code{\link{address_cleaner}} function.
This vector becomes the starting point of the distance calculation.
If the length of this parameter is 1 and destination's length is greater than 1, address is replicated to match the length of destination
(e.g., when you are calculating distances between one specific location and two or more destinations).
Note: addresses should be in raw form, \emph{not} URL encoded (e.g., of the form: 123 Main Street, Somewhere, NY 12345 USA)(country is optional but recommended).}

\item{dest}{A 1xN vector of destinations. These may be either (1) latitude and longitude coordinates
(formatted as "lat,long" with no spaces) or physical addresses that contain "url-safe" UTF-8 characters.
Enabling the "clean" parameter (see below) attempts to strip or replace common character patterns
from the input that are incompatible with the Google Maps API using the \code{\link{address_cleaner}} function.}

\item{auth}{character string; one of: "work" (the default), or "standard_api".
While you may specify an empty string for privkey when using the standard API, for some direction types (e.g., transit) a (free) API key from Google is required (see \href{https://developers.google.com/maps/documentation/javascript/get-api-key#get-an-api-key}{this page}).
Authentication via the "work" method requires the client ID and private API key associated with your (paid) \href{https://www.google.com/work/}{Google for Work/Premium} account.}

\item{privkey}{character string; your Google API key (whether of the "work" or "standard_api" variety).}

\item{clientid}{character string; your Google for Work client id (generally of the form 'gme-[company]')
This parameter should not be set when authenticating through the standard API.}

\item{clean}{logical; when \code{TRUE}, applies \code{\link{address_cleaner}} to the address and destination vectors.}

\item{travel_mode}{character string; currently, valid values include (\href{https://developers.google.com/maps/documentation/javascript/distancematrix#distance_matrix_requests}{see this page for details}):
\itemize{
\item driving (the default): indicates standard driving directions using the road network.
\item transit: requests directions via public transit routes (requires and API key).
\item walking: requests walking directions via pedestrian paths & sidewalks (where available).
\item bicycling: requests bicycling directions via bicycle paths & preferred streets (currently only available in the US and some Canadian cities).
      }}

\item{units}{character string; must be either "metric" (the default) or "imperial".
Specifying "metric" will return distance between origin and destination as kilometers,
whereas "imperial" returns distance in miles. For geocode requests this parameter
is ignorned if non-null.}

\item{verbose}{logical; when \code{TRUE}, displays additional progress output.}

\item{add_date}{character string; one of: "none" (the default), "today", or "fuzzy". When set to "today", a column with today's calendar date is added to the returned data frame.
When set to "fuzzy", a random positive number of days between 1 and 30 is added to this date column. "Fuzzy" date values can be useful to avoid sending large batches of geocode requests on the same day if your scripts recertify/retry distance calculations after a fixed period of time.}

\item{language}{character string; localization of the returned object. By default, this parameter is set to "en-EN", but refer to
\href{https://developers.google.com/maps/faq#using-google-maps-apis}{this page}
for an up-to-date list of all supported languages.}

\item{messages}{logical; when \code{TRUE}, displays warning and error messages generated by the API calls within the \code{\link{pull_geo_data}} function (e.g. connection errors, malformed signatures, etc.)}

\item{small}{logical; when \code{TRUE}, only distance (as per \code{units}), travel time (in hours), and (optionally, via \code{add_date}) the calendar date are returned.}
}
\value{
Drive_time returns a data frame (when all_vars is \code{TRUE}) with the following parameters stored from the response object:
\itemize{
	 \item \strong{origin:} The starting address Google used for the distance estimation.
	 \item \strong{destination:} The ending address Google used for the distance estimation.
	 \item \strong{dist_num:} The distance between \code{address} and \code{dest}
	 in miles or kilometers, as per the \code{units} parameter.
	 \item \strong{dist_txt:} Google's textual description of the distance between \code{address} and \code{dest}.
	 \item \strong{time_secs:} Estimated travel time in seconds given the specified mode of transportation.
	 \item \strong{time_mins:} Estimated travel time in minutes given the specified mode of transportation.
	 \item \strong{time_hours:} Estimated travel time in hours given the specified mode of transportation.
	 \item \strong{time_txt:} Google's textual description of the travel time between \code{address} and \code{dest}
  \item \strong{return_stat:} Google's status for the travel estimation. This field is null when their are
  connection or signature issues. The most common values of \code{return_stat} are
  \itemize{
  \item \emph{OK:} Generally indicates that no errors occurred; the addresses were successfully parsed and a distance/travel time estimate was returned.
  \item \emph{ZERO_RESULTS:} Generally indicates that the approximate locations were found but there were no distance/travel time estimations returned.
  \item \emph{ZERO_RESULTS:} Generally indicates that approximate locations could not be found and, thus, no distance/travel time estimations were returned. This may occur if you pass Google an empty address string.
  }
  \item \strong{status:} Overall status of the API request. Generally, this takes one of two values
  \itemize{
  \item \emph{OK:} Generally indicates indicates that a connection was made; see return_stat for additional information about the returned parameter estimates.
  \item \emph{OVER_QUERY_LIMIT:} Indicates that you are over your quota.
  \item \emph{REQUEST_DENIED:} Indicates that your request was denied.
  \item \emph{INVALID_REQUEST:} Indicates that some part of the query (address, URL components, etc.) is missing.
  \item \emph{UNKNOWN_ERROR:} indicates that the request could not be processed due to a server error. The request may succeed if you try again.
  \item \emph{CONNECTION_ERROR:} This status is generated by error-handling within the \code{placement} package, and suggests a connection error orcurred
  while fetch the url(s) (e.g. due to intermittent internet connectivity, problems reaching the Google maps API, etc.).
  }
  \item \strong{input_url:} character; the full url associated with the response object.
  }
}
\description{
This function uses the Google Maps API to estimate travel time and distance between two physical addresses.
Optionally, one may use a (paid) \href{https://www.google.com/work/}{Google for Work} API key to sign the request with the \code{\link{hmac}} sha1 algorithm.
For smaller batch requests, it is also possible to access Google's "standard API"
with this function (see \href{https://developers.google.com/maps/documentation/javascript/get-api-key#get-an-api-key}{this page} to obtain a free API key).
}
\examples{
# Bike from the NYC to Google!
address <- c("350 5th Ave, New York, NY 10118, USA",
			 "1600 Amphitheatre Pkwy, Mountain View, CA 94043, USA")

coordset <- geocode_url(address, auth="standard_api", privkey="",
            clean=TRUE, add_date='today', verbose=TRUE)

# Save coordinates. Google requires a format of: "lat,lng" (with no spaces)
start <- paste(coordset$lat[1],coordset$lng[1], sep=",")
end <- paste(coordset$lat[2],coordset$lng[2], sep=",")

# Get the travel time by bike (a mere 264 hours!) and distance in miles:
howfar_miles <- drive_time(address=start, dest=end, auth="standard_api",
						   privkey="", clean=FALSE, add_date='today',
						   verbose=FALSE, travel_mode="bicycling",
						   units="imperial")

# Get the distance in kilometers using physical addresses instead of lat/lng:
howfar_kms <- drive_time(
     address="350 5th Ave, New York, NY 10118, USA",
		dest="1600 Amphitheatre Pkwy, Mountain View, CA 94043",
		auth="standard_api", privkey="", clean=FALSE,
		add_date='today', verbose=FALSE, travel_mode="bicycling",
		units="imperial"
		)

with(howfar_kms, cat("Cycling from NYC to ", destination,
					 ":\\n", dist_txt, "\\n", time_txt, sep=""))
}

