% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/address_cleaner.R
\name{address_cleaner}
\alias{address_cleaner}
\title{A general address cleaner.}
\usage{
address_cleaner(address, verbose = TRUE)
}
\arguments{
\item{address}{A raw 1xN vector of UTF-8 encoded addresses.
Note: these addresses should be in raw form, \emph{not} URL encoded (e.g., of the form: 123 Main Street, Somewhere, NY 12345 USA)(country is optional but recommended).}

\item{verbose}{Displays additional progress output}
}
\value{
address_cleaner returns a character vector of addresses of the same length as the input.
}
\description{
Performs character transformations on a vector of
addresses in order to build "web-safe" URLs for the Google API.
}
\details{
This function strips character values from a vector of addresses (e.g., a vector of the form: address, city, state, postal code, country)
that may inhibit sucessful geocoding with the \href{https://developers.google.com/maps/documentation/geocoding/start}{Google maps API}.
Specifically, address_cleaner:
\itemize{
  \item {Replaces non-breaking spaces with " "}
  \item {Removes ASCII control characters (001-031 and 177)}
  \item {Trims runs of spaces and spaces which begin/end a string}
  \item {Converts special addressing characters, such as ordinals}
  \item {Removes single/double quotes and asterisks}
  \item {Strips latin1 characters}
  \item {Removes leading, trailing, and repeated commas}
  \item {Removes various permutations of the "c/o" flag}
  }

Note: Hypthenated addresses and zipcodes can cause issues with the Maps API. Therefore, prior to
applying this function and attempting to geocode a location, we recommend:
\itemize{
  \item {Deleting the second half of a compound US postal code, e.g. \code{gsub("(?<=\\d)-.*", "", "12345-1234", perl=TRUE)}}
  \item {Replacing hypthenated street numbers with a space followed by a pound, e.g. \code{gsub("(?<=\\d)-(?=\\d)", " #", "1234-3332 West 100th", perl=T)}.}
  }
  Both of these transformations, of course, presuppose that your postal code and street numbers exist in separate columns.
  Similarly, you may want to recode any "CA" country code fields to "Canada" to avoid inaccurate
  geocoding within California state (this is more more likely to occur when a Canadian address has non-standard features, such as 'c/o' or 'attn' fields, etc.).
}
\examples{
# Define an incompatible vector of addresses
address <- c(" 350 Fifth Ave \\u00bd, New York, NY 10118, USA ",
			 "  \\u00ba 1600  Amphitheatre Pkwy, Mountain View, CA 94043, USA")

# View the return:
address_cleaner(address)
}

