% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{models}
\alias{models}
\alias{FFPK}
\alias{pbtk1cpt_model}
\alias{pbpk_apap_model}
\title{Example PK Model for Sensitivity Analysis}
\usage{
FFPK(params, time, dose = 1)

pbtk1cpt_model()

pbpk_apap_model()
}
\arguments{
\item{params}{a parameter matrix containing the input sample.}

\item{time}{the given time-points.}

\item{dose}{a given dose.}
}
\description{
Three examples are included: Flip-flop pharmacokinetic model,
one-compartment toxicokinetic model from \pkg{httk} (Pearce et al. 2017),
and acetaminophen pharmacokinetic model (Zurlinden et al. 2016).
}
\section{Functions}{
\itemize{
\item \code{pbtk1cpt_model}: Download pbtk1cpt.model file.

\item \code{pbpk_apap_model}: Download pbpk_apap.model file.
}}

\examples{
params <- c(F = 0.9, KA = 1.2, KE = 0.2, V = 1.5)
t <- seq(0, 12, 0.1)
C <-FFPK(params = params, time = t)
plot(t, C, type = "l", xlab = "time", ylab = "concentration")

}
\references{
R. Pearce, R. Setzer, C. Strope, N. Sipes and J. Wambaugh, 2017,
httk: R Package for High-Throughput Toxicokinetics,
\emph{Journal of Statistical Software}, 79(4), 1-26.

T. J. Zurlinden and B. Reisfeld, 2016,
Physiologically based modeling of the pharmacokinetics of acetaminophen
and its major metabolites in humans using a Bayesian population approach,
\emph{European Journal of Drug Metabolism and Pharmacokinetics}, 79(4), 1-26.
}
