% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build-articles.R
\name{build_articles}
\alias{build_articles}
\alias{build_article}
\alias{build_articles_index}
\title{Build articles section}
\usage{
build_articles(
  pkg = ".",
  quiet = TRUE,
  lazy = TRUE,
  override = list(),
  preview = NA
)

build_article(name, pkg = ".", data = list(), lazy = FALSE, quiet = TRUE)

build_articles_index(pkg = ".")
}
\arguments{
\item{pkg}{Path to package.}

\item{quiet}{Set to \code{FALSE} to display output of knitr and
pandoc. This is useful when debugging.}

\item{lazy}{If \code{TRUE}, will only re-build article if input file has been
modified more recently than the output file.}

\item{override}{An optional named list used to temporarily override
values in \verb{_pkgdown.yml}}

\item{preview}{If \code{TRUE}, or \code{is.na(preview) && interactive()}, will preview
freshly generated section in browser.}

\item{name}{Name of article to render. This should be either a path
relative to \verb{vignettes/} without extension, or \code{index} or \code{README}.}

\item{data}{Additional data to pass on to template.}
}
\description{
\code{build_articles()} renders each R Markdown file underneath \verb{vignettes/} and
saves it to \verb{articles/}. There are two exceptions:
\itemize{
\item Files that start with \verb{_} (e.g., \verb{_index.Rmd}) are ignored,
enabling the use of child documents in
\href{https://bookdown.org/yihui/bookdown/}{bookdown}
\item Files in \code{vignettes/tutorials} are handled by \code{\link[=build_tutorials]{build_tutorials()}}
}

Vignettes are rendered using a special document format that reconciles
\code{\link[rmarkdown:html_document]{rmarkdown::html_document()}} with the pkgdown template. This means articles
behave slightly differently to vignettes, particularly with respect to
external files, and custom output formats. See below for more details.

Note that when you run \code{build_articles()} directly (outside of
\code{\link[=build_site]{build_site()}}) vignettes will use the currently installed version of the
package, not the current source version. This makes iteration quicker when
you are primarily working on the text of an article.
}
\section{Index and navbar}{

You can control the articles index and navbar with a \code{articles} section in
your \verb{_pkgdown.yaml}. It defines a list of sections, each of which
can contain four fields:
\itemize{
\item \code{title} (required): title of section, which appears as a heading on the
articles index.
\item \code{desc} (optional): An optional markdown description displayed underneath
the section title.
\item \code{navbar} (optional): A couple of words used to label this section in
the navbar. If omitted, this section of vignettes will not appear in the
navbar.
\item \code{contents} (required): a list of article names to include in the
section. This can either be names of individual vignettes or a
call to \code{starts_with()}. The name of a vignette includes its
path under \code{vignettes} without extension so that the name of the vignette
found at \code{vignettes/pizza/slice.Rmd} is \code{pizza/slice}.
}

The title and description of individual vignettes displayed on the index
comes from \code{title} and \code{description} fields of the YAML header in the Rmds.

For example, this yaml might be used for some version of dplyr:\preformatted{articles:
- title: Main verbs
  navbar: ~
  contents:
  - one-table
  - two-table
  - rowwise
  - colwise

- title: Developer
  desc: Vignettes aimed at package developers
  contents:
  - programming
  - packages
}

Note the use of the \code{navbar} fields. \verb{navbar: ~} means that the "Main verbs"
will appear in the navbar without a heading; the absence of the \code{navbar}
field in the for the developer vignettes means that they will only be
accessible via the articles index.

The navbar will include a link to the articles index if one or more
vignettes are not available through the navbar. If some vignettes appear
in the navbar drop-down list and others do not, the list will automatically
include a "More ..." link at the bottom; if no vignettes appear in the
the navbar, it will link directly to the articles index instead of
providing a drop-down.
}

\section{Get started}{

Note that a vignette with the same name as the package (e.g.,
\code{vignettes/pkgdown.Rmd} or \code{vignettes/articles/pkgdown.Rmd}) automatically
becomes a top-level "Get started" link, and will not appear in the articles
drop-down.

(If your package name includes a \code{.}, e.g. \code{pack.down}, use a \code{-} in the
vignette name, e.g. \code{pack-down.Rmd}.)
}

\section{External files}{

pkgdown differs from base R in its handling of external files. When building
vignettes, R assumes that vignettes are self-contained (a reasonable
assumption when most vignettes were PDFs) and only copies files explicitly
listed in \code{.install_extras}. pkgdown takes a different approach based on
\code{\link[rmarkdown:find_external_resources]{rmarkdown::find_external_resources()}}, and it will also copy any images that
you link to. If for some reason the automatic detection doesn't work, you
will need to add a \code{resource_files} field to the yaml metadata, e.g.:\preformatted{---
title: My Document
resource_files:
  - data/mydata.csv
  - images/figure.png
---
}

Note that you can not use the \code{fig.path} to change the output directory of
generated figures as its default value is a strong assumption of rmarkdown.
}

\section{Embedding Shiny apps}{

If you would like to embed a Shiny app into an article, the app will have
to be hosted independently, (e.g. \url{https://www.shinyapps.io}). Then, you
can embed the app into your article using an \verb{<iframe>}, e.g.
\verb{<iframe src = "https://gallery.shinyapps.io/083-front-page" class="shiny-app">}.

See \url{https://github.com/r-lib/pkgdown/issues/838#issuecomment-430473856} for
some hints on how to customise the appearance with CSS.
}

\section{YAML header}{

By default, pkgdown builds all articles with \code{\link[rmarkdown:html_document]{rmarkdown::html_document()}}
by setting the \code{template} parameter. This overrides any custom settings
you have in your YAML metadata, ensuring that all articles are rendered
in the same way (and receive the default site template).

If you need to override the output format, or set any options, you'll need
to add a \code{pkgdown} field to your yaml metadata:\preformatted{pkgdown:
  as_is: true
}

This will tell pkgdown to use the \code{output_format} (and options) that you
have specified. This format must accept \code{template}, \code{theme}, and
\code{self_contained} in order to work with pkgdown.

If the output format produces a PDF, you'll also need to specify the
\code{extension} field:\preformatted{pkgdown:
  as_is: true
  extension: pdf
}

If you want to set an output format for all your articles, you can do that
by adding a \verb{vignettes/_site.yml}, much like you would for an
\href{https://rmarkdown.rstudio.com/docs/reference/render_site.html}{rmarkdown website}.
For example, you can backport some bookdown features such as cross-references
to all your articles by using the
\href{https://bookdown.org/yihui/bookdown/a-single-document.html}{bookdown::html_document2}
format.\preformatted{output:
  bookdown::html_document2:
  number_sections: false
}
}

\section{Suppressing vignettes}{

If you want articles that are not vignettes, either put them in
subdirectories or list in \code{.Rbuildignore}. An articles link will be
automatically added to the default navbar if the vignettes directory is
present: if you do not want this, you will need to customise the navbar. See
\code{\link[=build_site]{build_site()}} details.
}

\section{Tables of contents}{

You can control the TOC depth via the YAML configuration file:\preformatted{toc:
  depth: 2
}
}

\section{Figures}{


You can control the default rendering of figures by specifying the \code{figures}
field in \verb{_pkgdown.yml}. The default settings are equivalent to:\preformatted{figures:
  dev: ragg::agg_png
  dpi: 96
  dev.args: []
  fig.ext: png
  fig.width: 7.2916667
  fig.height: ~
  fig.retina: 2
  fig.asp: 1.618
  bg: NA
}
}

