% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{pkg_downloads}
\alias{pkg_downloads}
\alias{pkg_download_result}
\title{Package downloads}
\description{
The \code{\link{pkg_download_proposal}} and \code{\link{pkg_installation_proposal}} classes
both have download methods, to downloads package files into a
configured directory (see \link[=pkg_config]{'Configuration'}).
}
\details{
They return a \code{pkg_download_result} object, which is a data frame
(tibble), that adds extra columns to \code{\link{pkg_resolution_result}} (for
\code{\link{pkg_download_proposal}}) or \code{\link{pkg_solution_result}}
(for \code{\link{pkg_installation_proposal}}):
\itemize{
\item \code{fulltarget}: absolute path to the downloaded file. At most one of
\code{fulltarget} and \code{fulltarget_tree} must exist on the disk.
\item \code{fulltarget_tree}: absolute path to a package tree directory. At most
one of \code{fulltarget} and \code{fulltarget_tree} must exist on the disk.
\item \code{download_status}: \code{"Had"} or \code{"Got"}, depending on whether the file
was obtained from the cache.
\item \code{download_error}: error object for failed downloads.
\item \code{file_size}: Size of the file, or \code{NA}. For \verb{installed::} refs, it is
\code{NA}, and it is also \code{NA} for refs that created \code{fulltarget_tree}
instead of \code{fulltarget}.
}

\code{fulltarget}, if it exists, contains a packaged (via \verb{R CMD build})
source R package. If \code{fulltarget_tree} exists, it is a package tree
directory, that still needs an \verb{R CMD build} call.
}
