% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache-api.R
\name{pkg_cache_summary}
\alias{pkg_cache_summary}
\alias{pkg_cache_list}
\alias{pkg_cache_find}
\alias{pkg_cache_get_file}
\alias{pkg_cache_delete_files}
\alias{pkg_cache_add_file}
\title{Functions to query and manipulate the package cache}
\usage{
pkg_cache_summary(cachepath = NULL)

pkg_cache_list(cachepath = NULL)

pkg_cache_find(cachepath = NULL, ...)

pkg_cache_get_file(cachepath = NULL, target, ...)

pkg_cache_delete_files(cachepath = NULL, ...)

pkg_cache_add_file(cachepath = NULL, file, relpath = dirname(file), ...)
}
\arguments{
\item{cachepath}{Path of the cache. By default the cache directory is in
\code{R-pkg}, within the user's cache directory.
See \code{\link[rappdirs:user_cache_dir]{rappdirs::user_cache_dir()}}.}

\item{...}{Extra named arguments to select the package file.}

\item{target}{Path where the selected file is copied.}

\item{file}{File to add.}

\item{relpath}{The relative path of the file within the cache.}
}
\description{
\code{pkg_cache_summary()} returns a short summary of the state of the cache,
e.g. the number of files and their total size. It returns a named list.
}
\examples{
\dontshow{if (FALSE) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
pkg_cache_summary()
pkg_cache_list()
pkg_cache_find(package = "forecast")
tmp <- tempfile()
pkg_cache_get_file(target = tmp, package = "forecast", version = "8.10")
pkg_cache_delete_files(package = "forecast")
\dontshow{\}) # examplesIf}
}
\seealso{
The \link{package_cache} R6 class for a more flexible API.
}
